/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.mixin.NoiseGeneratorSettingsAccessor;
import net.bunten.enderscape.registry.EnderscapeSurfaceRuleData;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract RegistryAccess.Frozen registryAccess();

    @Inject(at={@At(value="TAIL")}, method={"createLevels"})
    private void addSurfaceRules(ChunkProgressListener listener, CallbackInfo ci) {
        HolderLookup.RegistryLookup value = this.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
        LevelStem stem = (LevelStem)value.getOrThrow(LevelStem.END).value();
        ChunkGenerator chunkGenerator = stem.generator();
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator generator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)generator.generatorSettings().value();
            NoiseGeneratorSettingsAccessor accessor = (NoiseGeneratorSettingsAccessor)settings;
            accessor.setSurfaceRule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{EnderscapeSurfaceRuleData.makeRules(), settings.surfaceRule()}));
        }
    }
}

