/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.List;
import java.util.function.Predicate;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={NearestAttackableTargetGoal.class})
public abstract class NearestAttackableTargetGoalMixin<T extends LivingEntity>
extends TargetGoal {
    public NearestAttackableTargetGoalMixin(Mob mob, boolean bl) {
        super(mob, bl);
    }

    @Redirect(method={"findTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"))
    private <B extends Entity> List<B> redirectGetEntitiesOfClass(Level instance, Class<B> entityClass, AABB aabb, Predicate<? super B> predicate) {
        return instance.getEntitiesOfClass(entityClass, aabb, entity -> {
            if (this.mob instanceof EnderMan && entity instanceof Endermite) {
                Endermite endermite = (Endermite)entity;
                return NearestAttackableTargetGoalMixin.isEndermiteUnsafe((LivingEntity)endermite, instance);
            }
            return predicate.test((Object)entity);
        });
    }

    private static boolean isEndermiteUnsafe(LivingEntity entity, Level level) {
        return BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)6, (int)6, pos -> level.getBlockState(pos).is(EnderscapeBlockTags.ENDERMITE_SAFE_WHEN_NEARBY)).isEmpty();
    }
}

