/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.HashMap;
import java.util.Map;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.item.MagniaAttractorItem;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.RubbleShieldItem;
import net.bunten.enderscape.item.component.DashJump;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private int Enderscape$airTicks = 0;
    @Unique
    private final Player player = (Player)this;
    @Unique
    private final Map<Entity, Integer> Enderscape$magniaTrackedEntities = new HashMap<Entity, Integer>();
    @Unique
    private final Map<Entity, Integer> Enderscape$pullTickCounters = new HashMap<Entity, Integer>();

    @Shadow
    public abstract Inventory getInventory();

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"jumpFromGround"})
    public void Enderscape$jumpFromGround(CallbackInfo info) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.player;
            if (level instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)level;
                if (this.isUsingItem() && this.getUseItem().has(EnderscapeDataComponents.DASH_JUMP)) {
                    ((DashJump)this.getUseItem().get(EnderscapeDataComponents.DASH_JUMP)).apply(serverLevel, serverPlayer, this.player.getUseItem(), (DashJump)this.player.getUseItem().get(EnderscapeDataComponents.DASH_JUMP));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void Enderscape$tick(CallbackInfo info) {
        this.Enderscape$tickMagniaAttractorItemMovement();
        int n = this.Enderscape$airTicks = !this.onGround() && !this.isInWater() ? this.Enderscape$airTicks + 1 : 0;
        if (this.isFallFlying() && this.isShiftKeyDown() && EnderscapeConfig.getInstance().elytraSneakToStopGliding) {
            ((Player)this).stopFallFlying();
        }
    }

    @Unique
    private void Enderscape$tickMagniaAttractorItemMovement() {
        if (this.isAlive() && !this.isSpectator() && !this.level().isClientSide()) {
            ItemStack stack = MagniaAttractorItem.getValidAttractor(this.getInventory());
            if (!stack.isEmpty() && MagniaAttractorItem.isEnabled(stack)) {
                int range = MagniaAttractorItem.getEntityPullRange(stack);
                AABB inflated = this.getBoundingBox().inflate((double)range, 4.0, (double)range);
                NebuliteToolContext context = new NebuliteToolContext(stack, this.level(), (LivingEntity)((Player)this));
                this.level().getEntitiesOfClass(ItemEntity.class, inflated).stream().filter(item -> !item.hasPickUpDelay()).forEach(entity -> this.Enderscape$pullEntity(context, (Entity)entity, 1));
                this.level().getEntitiesOfClass(ExperienceOrb.class, inflated).stream().filter(orb -> orb.tickCount >= 20).forEach(entity -> this.Enderscape$pullEntity(context, (Entity)entity, 0));
                this.Enderscape$magniaTrackedEntities.entrySet().removeIf(entry -> {
                    Entity item = (Entity)entry.getKey();
                    int cooldown = (Integer)entry.getValue();
                    if (this.position().distanceTo(item.position()) > (double)range) {
                        if (cooldown >= 20) {
                            MagniaMovingData.setMovedByMagnia(item, false);
                            return true;
                        }
                        entry.setValue(cooldown + 1);
                    } else {
                        entry.setValue(0);
                    }
                    return false;
                });
            }
            this.Enderscape$pullTickCounters.entrySet().removeIf(entry -> !MagniaMovingData.wasMovedByMagnia((Entity)entry.getKey()));
        }
    }

    @Unique
    private void Enderscape$pullEntity(NebuliteToolContext context, Entity entity, int abuseCost) {
        LivingEntity livingEntity;
        ItemStack stack = context.stack();
        if (!this.Enderscape$magniaTrackedEntities.containsKey(entity)) {
            if (!MagniaMovingData.wasMovedByMagnia(entity)) {
                this.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), EnderscapeItemSounds.MAGNIA_ATTRACTOR_MOVE.get(), entity.getSoundSource(), 1.0f, 1.0f);
            }
            this.Enderscape$magniaTrackedEntities.put(entity, 0);
        }
        Vec3 speed = this.position().subtract(entity.position()).normalize().scale(entity.isUnderWater() ? 0.04 : 0.2);
        entity.setDeltaMovement(entity.getDeltaMovement().add(speed));
        MagniaMovingData.setMovedByMagnia(entity, true);
        if (abuseCost > 0) {
            if (MagniaMovingData.wasMovedByMagnia(entity)) {
                int ticks = this.Enderscape$pullTickCounters.getOrDefault(entity, 0) + 1;
                if (ticks >= 40) {
                    MagniaAttractorItem.incrementEntitiesPulled(stack, abuseCost);
                    MagniaAttractorItem.tryUseFuel(context, abuseCost - MagniaAttractorItem.getEntitiesPulledToUseFuel(stack));
                    ticks = 0;
                }
                this.Enderscape$pullTickCounters.put(entity, ticks);
            } else {
                this.Enderscape$pullTickCounters.remove(entity);
            }
        }
        if ((livingEntity = context.user()) instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)livingEntity;
            EnderscapeCriteria.PULL_ENTITY.trigger(server, entity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tryToStartFallFlying"}, cancellable=true)
    public void Enderscape$tryToStartFallFlying(CallbackInfoReturnable<Boolean> cir) {
        if (this.Enderscape$airTicks < 5) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"startFallFlying"})
    public void Enderscape$startFallFlying(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().elytraAddOpenCloseSounds) {
            this.playSound(EnderscapeItemSounds.ELYTRA_START_GLIDING.get(), 1.0f, Mth.nextFloat((RandomSource)this.getRandom(), (float)0.8f, (float)1.2f));
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)-68);
    }

    @Inject(at={@At(value="HEAD")}, method={"stopFallFlying"})
    public void Enderscape$stopFallFlying(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().elytraAddOpenCloseSounds) {
            this.playSound(EnderscapeItemSounds.ELYTRA_STOP_GLIDING.get(), 1.0f, Mth.nextFloat((RandomSource)this.getRandom(), (float)0.8f, (float)1.2f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurtCurrentlyUsedShield"})
    private void Enderscape$redirectShieldCheck(float f, CallbackInfo info) {
        if (this.useItem.getItem() instanceof RubbleShieldItem) {
            if (!this.level().isClientSide) {
                this.player.awardStat(Stats.ITEM_USED.get((Object)this.useItem.getItem()));
            }
            if (f >= 3.0f) {
                int i = 1 + Mth.floor((float)f);
                InteractionHand hand = this.getUsedItemHand();
                this.useItem.hurtAndBreak(i, (LivingEntity)this, PlayerMixin.getSlotForHand((InteractionHand)hand));
                if (this.useItem.isEmpty()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    } else {
                        this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    }
                    this.useItem = ItemStack.EMPTY;
                    this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }
}

