/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.EnderscapeConfig;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShulkerBullet.class})
public abstract class ShulkerBulletMixin
extends Projectile {
    @Shadow
    @Nullable
    private Entity finalTarget;

    @Shadow
    protected abstract void destroy();

    public ShulkerBulletMixin(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(CallbackInfo info) {
        boolean ownerInvalid;
        boolean pastTimeLimit = EnderscapeConfig.getInstance().shulkerBulletEnforceTimeLimit > 0 && this.tickCount > EnderscapeConfig.getInstance().shulkerBulletEnforceTimeLimit * 20;
        boolean pastDistance = EnderscapeConfig.getInstance().shulkerBulletEnforceDistanceLimit > 0 && this.finalTarget != null && this.distanceTo(this.finalTarget) >= (float)EnderscapeConfig.getInstance().shulkerBulletEnforceDistanceLimit;
        boolean bl = ownerInvalid = EnderscapeConfig.getInstance().shulkerBulletEnforceOwnerLimit && (this.getOwner() == null || !this.getOwner().isAlive());
        if (pastTimeLimit || pastDistance || ownerInvalid) {
            this.destroy();
            info.cancel();
        }
    }

    @ModifyArg(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"))
    protected MobEffectInstance onHitEntity(MobEffectInstance original) {
        if (EnderscapeConfig.getInstance().shulkerBulletRebalanceLevitation) {
            return new MobEffectInstance(MobEffects.LEVITATION, 80, 2);
        }
        return original;
    }
}

