/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TemptingSensor.class})
public abstract class TemptingSensorMixin {
    @Unique
    private static final TargetingConditions Enderscape$DRIFTER_TEMPT_TARGETING = TargetingConditions.forNonCombat().range(24.0).ignoreLineOfSight();

    @Shadow
    protected abstract boolean playerHoldingTemptation(Player var1);

    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/PathfinderMob;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void Enderscape$modifyDrifterTemptDistance(ServerLevel level, PathfinderMob mob, CallbackInfo info) {
        if (mob instanceof AbstractDrifter) {
            AbstractDrifter drifter = (AbstractDrifter)mob;
            Brain<AbstractDrifter> brain = drifter.getBrain();
            List list = level.players().stream().filter(EntitySelector.NO_SPECTATORS).filter(player -> Enderscape$DRIFTER_TEMPT_TARGETING.test((LivingEntity)drifter, (LivingEntity)player)).filter(player -> drifter.closerThan((Entity)player, 24.0)).filter(this::playerHoldingTemptation).filter(player -> !drifter.hasPassenger((Entity)player)).sorted(Comparator.comparingDouble(arg_0 -> ((AbstractDrifter)drifter).distanceToSqr(arg_0))).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Player player2 = (Player)list.get(0);
                brain.setMemory(MemoryModuleType.TEMPTING_PLAYER, (Object)player2);
            } else {
                brain.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
            }
            info.cancel();
        }
    }
}

