/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={ThrownEnderpearl.class})
public abstract class ThrownEnderpearlMixin
extends ThrowableItemProjectile {
    public ThrownEnderpearlMixin(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    @ModifyArgs(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;)V"))
    private void Enderscape$playSound(Args args) {
        if (EnderscapeConfig.getInstance().enderPearlUpdateTeleportSound) {
            args.set(4, (Object)EnderscapeItemSounds.ENDER_PEARL_LAND.get());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"playSound"})
    public void Enderscape$playSound(CallbackInfo info) {
        Level level;
        if (EnderscapeConfig.getInstance().enderPearlBreakParticles && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), 12, 0.0, 0.0, 0.0, 0.1);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void Enderscape$tick(CallbackInfo info) {
        if (this.level().isClientSide() && EnderscapeConfig.getInstance().enderPearlAddParticles) {
            Vec3 vel = this.getDeltaMovement().scale(0.5).scale(-1.0);
            double x = this.random.nextGaussian() * 0.02 + vel.x;
            double y = this.random.nextGaussian() * 0.02 + vel.y;
            double z = this.random.nextGaussian() * 0.02 + vel.z;
            this.level().addParticle((ParticleOptions)EnderscapeParticles.ENDER_PEARL.get(), this.getRandomX(4.0) - vel.x / 2.0, this.getRandomY() - vel.y / 2.0 + 0.5, this.getRandomZ(4.0) - vel.z / 2.0, x, y, z);
        }
    }
}

