/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownTrident.class})
public abstract class ThrownTridentMixin
extends AbstractArrow {
    @Final
    @Shadow
    private static EntityDataAccessor<Byte> ID_LOYALTY;
    @Shadow
    private boolean dealtDamage;

    protected ThrownTridentMixin(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().tridentsReturnFromVoid && this.getOwner() != null && this.getY() < (double)this.level().getMinBuildHeight() && (Byte)this.entityData.get(ID_LOYALTY) > 0) {
            this.dealtDamage = true;
            this.teleportTo(this.getOwner().getX(), this.getOwner().getY(), this.getOwner().getZ());
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.playSound(EnderscapeItemSounds.TRIDENT_WARP.get());
        }
    }
}

