/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrialSpawnerState.class})
public class TrialSpawnerStateMixin {
    @Shadow
    @Final
    private TrialSpawnerState.ParticleEmission particleEmission;

    @Unique
    private static void addParticle(SimpleParticleType type, Vec3 vec3, Level level) {
        level.addParticle((ParticleOptions)type, vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
    }

    @Inject(method={"emitParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void Enderscape$emitParticles(Level level, BlockPos pos, boolean bl, CallbackInfo info) {
        if (level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            Vec3 vec3;
            RandomSource random = level.getRandom();
            if (this.particleEmission == TrialSpawnerState.ParticleEmission.SMALL_FLAMES && random.nextInt(2) == 0) {
                TrialSpawnerStateMixin.addParticle(ParticleTypes.PORTAL, pos.getCenter().offsetRandom(random, 0.9f), level);
            }
            if (this.particleEmission == TrialSpawnerState.ParticleEmission.FLAMES_AND_SMOKE) {
                vec3 = pos.getCenter().offsetRandom(random, 1.0f);
                TrialSpawnerStateMixin.addParticle(EnderscapeParticles.VOID_STARS.get(), vec3, level);
                TrialSpawnerStateMixin.addParticle(ParticleTypes.PORTAL, vec3, level);
            }
            if (this.particleEmission == TrialSpawnerState.ParticleEmission.SMOKE_INSIDE_AND_TOP_FACE) {
                vec3 = pos.getCenter().offsetRandom(random, 0.9f);
                if (random.nextInt(3) == 0) {
                    TrialSpawnerStateMixin.addParticle(EnderscapeParticles.VOID_STARS.get(), vec3, level);
                }
                if (level.getGameTime() % 40L == 0L) {
                    for (int j = 0; j < level.getRandom().nextInt(4) + 20; ++j) {
                        Vec3 center = pos.getCenter();
                        double horizontalRadius = 0.01;
                        level.addParticle((ParticleOptions)EnderscapeParticles.END_TRIAL_SPAWNER_EXHALE.get(), center.x, center.y + 0.5, center.z, Mth.nextDouble((RandomSource)random, (double)(-horizontalRadius), (double)horizontalRadius), Mth.nextDouble((RandomSource)random, (double)0.02, (double)0.04), Mth.nextDouble((RandomSource)random, (double)(-horizontalRadius), (double)horizontalRadius));
                    }
                }
            }
            info.cancel();
        }
    }
}

