/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.Set;
import java.util.UUID;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VaultBlockEntity.Client.class})
public abstract class VaultBlockEntityClientMixin {
    @Shadow
    private static void emitIdleParticles(Level level, BlockPos blockPos, VaultSharedData vaultSharedData, ParticleOptions particleOptions) {
    }

    @Shadow
    private static Vec3 keyholePos(BlockPos blockPos, Direction direction) {
        return null;
    }

    @Shadow
    private static boolean isWithinConnectionRange(BlockPos blockPos, VaultSharedData vaultSharedData, Player player) {
        return false;
    }

    @Inject(method={"emitConnectionParticlesForNearbyPlayers"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getStateWithConnections(Level level, BlockPos pos, BlockState blockState, VaultSharedData vaultSharedData, CallbackInfo info) {
        if (level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            Set set = vaultSharedData.getConnectedPlayers();
            if (!set.isEmpty()) {
                Vec3 vec3 = VaultBlockEntityClientMixin.keyholePos(pos, (Direction)blockState.getValue((Property)VaultBlock.FACING));
                for (UUID uUID : set) {
                    Player player = level.getPlayerByUUID(uUID);
                    if (player == null || !VaultBlockEntityClientMixin.isWithinConnectionRange(pos, vaultSharedData, player)) continue;
                    RandomSource randomSource = level.random;
                    Vec3 vec32 = vec3.vectorTo(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0));
                    int i = Mth.nextInt((RandomSource)randomSource, (int)2, (int)5);
                    for (int j = 0; j < i; ++j) {
                        Vec3 vec33 = vec32.offsetRandom(randomSource, 1.0f);
                        level.addParticle((ParticleOptions)EnderscapeParticles.END_VAULT_CONNECTION.get(), vec3.x(), vec3.y(), vec3.z(), vec33.x(), vec33.y(), vec33.z());
                    }
                }
            }
            info.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/vault/VaultBlockEntity$Client;emitIdleParticles(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/vault/VaultSharedData;Lnet/minecraft/core/particles/ParticleOptions;)V"))
    private static void getStateWithConnections(Level level, BlockPos pos, VaultSharedData data, ParticleOptions options) {
        if (level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            VaultBlockEntityClientMixin.emitIdleParticles(level, pos, data, (ParticleOptions)EnderscapeParticles.VOID_STARS.get());
        } else {
            VaultBlockEntityClientMixin.emitIdleParticles(level, pos, data, options);
        }
    }

    @Redirect(method={"playIdleSounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V"))
    private static void getStateWithConnections(Level level, BlockPos pos, SoundEvent sound, SoundSource source, float f, float g, boolean bl) {
        if (level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            level.playLocalSound(pos, EnderscapeBlockSounds.END_VAULT_AMBIENT, source, f, g, bl);
        } else {
            level.playLocalSound(pos, sound, source, f, g, bl);
        }
    }
}

