/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.network;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.DashJumpUserData;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundDashJumpDataPayload(int entityId, DashJumpUserData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundDashJumpDataPayload> TYPE = new CustomPacketPayload.Type(Enderscape.id("clientbound_dash_jump_data"));
    public static final StreamCodec<FriendlyByteBuf, ClientboundDashJumpDataPayload> STREAM_CODEC = CustomPacketPayload.codec(ClientboundDashJumpDataPayload::write, ClientboundDashJumpDataPayload::new);

    private ClientboundDashJumpDataPayload(FriendlyByteBuf buf) {
        this(buf.readInt(), (DashJumpUserData)DashJumpUserData.STREAM_CODEC.decode((Object)buf));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        DashJumpUserData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ClientboundDashJumpDataPayload payload, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(payload.entityId);
        if (entity != null) {
            entity.setData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get(), (Object)payload.data);
        }
    }
}

