/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.network;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.EndTrialSpawnableData;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundEndTrialSpawnableDataPayload(int entityId, EndTrialSpawnableData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundEndTrialSpawnableDataPayload> TYPE = new CustomPacketPayload.Type(Enderscape.id("clientbound_end_trial_spawnable_data"));
    public static final StreamCodec<FriendlyByteBuf, ClientboundEndTrialSpawnableDataPayload> STREAM_CODEC = CustomPacketPayload.codec(ClientboundEndTrialSpawnableDataPayload::write, ClientboundEndTrialSpawnableDataPayload::new);

    private ClientboundEndTrialSpawnableDataPayload(FriendlyByteBuf buf) {
        this(buf.readInt(), (EndTrialSpawnableData)EndTrialSpawnableData.STREAM_CODEC.decode((Object)buf));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        EndTrialSpawnableData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ClientboundEndTrialSpawnableDataPayload payload, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(payload.entityId);
        if (entity != null) {
            entity.setData(EnderscapeDataAttachments.END_TRIAL_SPAWNABLE_DATA.get(), (Object)payload.data);
        }
    }
}

