/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.network;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundMagniaDataPayload(int entityId, MagniaMovingData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundMagniaDataPayload> TYPE = new CustomPacketPayload.Type(Enderscape.id("clientbound_magnia_data"));
    public static final StreamCodec<FriendlyByteBuf, ClientboundMagniaDataPayload> STREAM_CODEC = CustomPacketPayload.codec(ClientboundMagniaDataPayload::write, ClientboundMagniaDataPayload::new);

    private ClientboundMagniaDataPayload(FriendlyByteBuf buf) {
        this(buf.readInt(), (MagniaMovingData)MagniaMovingData.STREAM_CODEC.decode((Object)buf));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        MagniaMovingData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ClientboundMagniaDataPayload payload, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(payload.entityId);
        if (entity != null) {
            entity.setData(EnderscapeDataAttachments.MAGNIA_MOVING_DATA.get(), (Object)payload.data);
        }
    }
}

