/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;

public class EnderscapeBannerPatterns {
    public static final List<ResourceKey<BannerPattern>> BANNER_PATTERNS = new ArrayList<ResourceKey<BannerPattern>>();
    public static final ResourceKey<BannerPattern> CRESCENT = EnderscapeBannerPatterns.register("crescent");

    public void bootstrap(BootstrapContext<BannerPattern> context) {
        EnderscapeBannerPatterns.register(context, CRESCENT);
    }

    public static void register(BootstrapContext<BannerPattern> context, ResourceKey<BannerPattern> key) {
        context.register(key, (Object)new BannerPattern(key.location(), "block.minecraft.banner." + key.location().toShortLanguageKey()));
    }

    private static ResourceKey<BannerPattern> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Enderscape.id(name));
        BANNER_PATTERNS.add((ResourceKey<BannerPattern>)key);
        return key;
    }
}

