/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.biome.CelestialGroveBiome;
import net.bunten.enderscape.biome.CorruptBarrensBiome;
import net.bunten.enderscape.biome.MagniaCragsBiome;
import net.bunten.enderscape.biome.VeiledWoodlandsBiome;
import net.bunten.enderscape.biome.VoidDepthsBiome;
import net.bunten.enderscape.biome.VoidSkiesBiome;
import net.bunten.enderscape.biome.VoidSkyIslandsBiome;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class EnderscapeBiomes {
    public static final int DEFAULT_SKY_COLOR = 1577761;
    public static final int DEFAULT_FOG_COLOR = 1117464;
    public static final int DEFAULT_GRASS_COLOR = 10598275;
    public static final int DEFAULT_FOLIAGE_COLOR = 10598275;
    public static final int DEFAULT_WATER_COLOR = 7961249;
    public static final int DEFAULT_WATER_FOG_COLOR = 3684693;
    public static final int DEFAULT_NEBULA_COLOR = 8084382;
    public static final float DEFAULT_NEBULA_ALPHA = 0.05f;
    public static final int DEFAULT_STAR_COLOR = 15305215;
    public static final float DEFAULT_STAR_ALPHA = 0.12f;
    public static final float CORRUPT_BARRENS_DARKENING_FACTOR = 0.65f;
    public static final float VOID_BIOMES_DARKENING_FACTOR = 0.35f;
    public static final List<ResourceKey<Biome>> BIOMES = new ArrayList<ResourceKey<Biome>>();
    public static final ResourceKey<Biome> CELESTIAL_GROVE = EnderscapeBiomes.register("celestial_grove");
    public static final ResourceKey<Biome> CORRUPT_BARRENS = EnderscapeBiomes.register("corrupt_barrens");
    public static final ResourceKey<Biome> MAGNIA_CRAGS = EnderscapeBiomes.register("magnia_crags");
    public static final ResourceKey<Biome> VEILED_WOODLANDS = EnderscapeBiomes.register("veiled_woodlands");
    public static final ResourceKey<Biome> VOID_DEPTHS = EnderscapeBiomes.register("void_depths");
    public static final ResourceKey<Biome> VOID_SKIES = EnderscapeBiomes.register("void_skies");
    public static final ResourceKey<Biome> VOID_SKY_ISLANDS = EnderscapeBiomes.register("void_sky_islands");

    public void bootstrap(BootstrapContext<Biome> context) {
        context.register(CELESTIAL_GROVE, (Object)CelestialGroveBiome.create(context));
        context.register(CORRUPT_BARRENS, (Object)CorruptBarrensBiome.create(context));
        context.register(MAGNIA_CRAGS, (Object)MagniaCragsBiome.create(context));
        context.register(VEILED_WOODLANDS, (Object)VeiledWoodlandsBiome.create(context));
        context.register(VOID_DEPTHS, (Object)VoidDepthsBiome.create(context));
        context.register(VOID_SKIES, (Object)VoidSkiesBiome.create(context));
        context.register(VOID_SKY_ISLANDS, (Object)VoidSkyIslandsBiome.create(context));
    }

    private static ResourceKey<Biome> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Enderscape.id(name));
        BIOMES.add((ResourceKey<Biome>)key);
        return key;
    }
}

