/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.block.AlluringMagniaBlock;
import net.bunten.enderscape.block.AlluringMagniaSproutBlock;
import net.bunten.enderscape.block.BlinklampBlock;
import net.bunten.enderscape.block.BlinklightVines;
import net.bunten.enderscape.block.BlinklightVinesBodyBlock;
import net.bunten.enderscape.block.BlinklightVinesHeadBlock;
import net.bunten.enderscape.block.BulbFlowerBlock;
import net.bunten.enderscape.block.BulbLanternBlock;
import net.bunten.enderscape.block.CelestialChanterelleBlock;
import net.bunten.enderscape.block.CelestialGrowthBlock;
import net.bunten.enderscape.block.CelestialOvergrowthBlock;
import net.bunten.enderscape.block.CelestialPathBlock;
import net.bunten.enderscape.block.ChanterelleCapBlock;
import net.bunten.enderscape.block.ChorusCakeRollBlock;
import net.bunten.enderscape.block.ChorusSproutsBlock;
import net.bunten.enderscape.block.CorruptGrowthBlock;
import net.bunten.enderscape.block.CorruptOvergrowthBlock;
import net.bunten.enderscape.block.CorruptPathBlock;
import net.bunten.enderscape.block.DriftJellyBlock;
import net.bunten.enderscape.block.DryEndGrowthBlock;
import net.bunten.enderscape.block.EndVaultBlock;
import net.bunten.enderscape.block.FlangerBerryFlowerBlock;
import net.bunten.enderscape.block.FlangerBerryVine;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.MurublightChanterelleBlock;
import net.bunten.enderscape.block.MurublightShelfBlock;
import net.bunten.enderscape.block.NebuliteOreBlock;
import net.bunten.enderscape.block.RepulsiveMagniaBlock;
import net.bunten.enderscape.block.RepulsiveMagniaSproutBlock;
import net.bunten.enderscape.block.RipeFlangerBerryBlock;
import net.bunten.enderscape.block.UnripeFlangerBerryBlock;
import net.bunten.enderscape.block.VeiledLeafPileBlock;
import net.bunten.enderscape.block.VeiledLeavesBlock;
import net.bunten.enderscape.block.VeiledOvergrowthBlock;
import net.bunten.enderscape.block.VeiledSaplingBlock;
import net.bunten.enderscape.block.VeiledVinesBlock;
import net.bunten.enderscape.block.VoidShaleBlock;
import net.bunten.enderscape.block.WispFlowerBlock;
import net.bunten.enderscape.block.WispGrowthBlock;
import net.bunten.enderscape.block.WispSproutsBlock;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeConfiguredFeatures;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeNoteBlockInstruments;
import net.bunten.enderscape.registry.EnderscapeSoundTypes;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeBlocks {
    public static final BlockSetType VEILED_BLOCK_SET = new BlockSetType("veiled", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, EnderscapeSoundTypes.VEILED_PLANKS, EnderscapeBlockSounds.VEILED_DOOR_CLOSE, EnderscapeBlockSounds.VEILED_DOOR_OPEN, EnderscapeBlockSounds.VEILED_TRAPDOOR_CLOSE, EnderscapeBlockSounds.VEILED_TRAPDOOR_OPEN, EnderscapeBlockSounds.VEILED_PRESSURE_PLATE_CLICK_OFF, EnderscapeBlockSounds.VEILED_PRESSURE_PLATE_CLICK_ON, EnderscapeBlockSounds.VEILED_BUTTON_CLICK_OFF, EnderscapeBlockSounds.VEILED_BUTTON_CLICK_ON);
    public static final BlockSetType CELESTIAL_BLOCK_SET = new BlockSetType("celestial", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, EnderscapeSoundTypes.CELESTIAL_PLANKS, EnderscapeBlockSounds.CELESTIAL_DOOR_CLOSE, EnderscapeBlockSounds.CELESTIAL_DOOR_OPEN, EnderscapeBlockSounds.CELESTIAL_TRAPDOOR_CLOSE, EnderscapeBlockSounds.CELESTIAL_TRAPDOOR_OPEN, EnderscapeBlockSounds.CELESTIAL_PRESSURE_PLATE_CLICK_OFF, EnderscapeBlockSounds.CELESTIAL_PRESSURE_PLATE_CLICK_ON, EnderscapeBlockSounds.CELESTIAL_BUTTON_CLICK_OFF, EnderscapeBlockSounds.CELESTIAL_BUTTON_CLICK_ON);
    public static final BlockSetType MURUBLIGHT_BLOCK_SET = new BlockSetType("murublight", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, EnderscapeSoundTypes.MURUBLIGHT_PLANKS, EnderscapeBlockSounds.MURUBLIGHT_DOOR_CLOSE, EnderscapeBlockSounds.MURUBLIGHT_DOOR_OPEN, EnderscapeBlockSounds.MURUBLIGHT_TRAPDOOR_CLOSE, EnderscapeBlockSounds.MURUBLIGHT_TRAPDOOR_OPEN, EnderscapeBlockSounds.MURUBLIGHT_PRESSURE_PLATE_CLICK_OFF, EnderscapeBlockSounds.MURUBLIGHT_PRESSURE_PLATE_CLICK_ON, EnderscapeBlockSounds.MURUBLIGHT_BUTTON_CLICK_OFF, EnderscapeBlockSounds.MURUBLIGHT_BUTTON_CLICK_ON);
    public static final BlockSetType POLISHED_END_STONE_BLOCK_SET = new BlockSetType("polished_end_stone", true, true, false, BlockSetType.PressurePlateSensitivity.MOBS, SoundType.STONE, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    public static final BlockSetType POLISHED_MIRESTONE_BLOCK_SET = new BlockSetType("polished_mirestone", true, true, false, BlockSetType.PressurePlateSensitivity.MOBS, EnderscapeSoundTypes.MIRESTONE, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    public static final BlockSetType POLISHED_VERADITE_BLOCK_SET = new BlockSetType("polished_veradite", true, true, false, BlockSetType.PressurePlateSensitivity.MOBS, EnderscapeSoundTypes.VERADITE, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    public static final BlockSetType POLISHED_KURODITE_BLOCK_SET = new BlockSetType("polished_kurodite", true, true, false, BlockSetType.PressurePlateSensitivity.MOBS, EnderscapeSoundTypes.KURODITE, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    public static final WoodType VEILED_WOOD_TYPE = EnderscapeBlocks.registerWoodType(Enderscape.id("veiled"), VEILED_BLOCK_SET, EnderscapeSoundTypes.VEILED_PLANKS, EnderscapeSoundTypes.VEILED_HANGING_SIGN, EnderscapeBlockSounds.VEILED_FENCE_GATE_CLOSE, EnderscapeBlockSounds.VEILED_FENCE_GATE_OPEN);
    public static final WoodType CELESTIAL_WOOD_TYPE = EnderscapeBlocks.registerWoodType(Enderscape.id("celestial"), CELESTIAL_BLOCK_SET, EnderscapeSoundTypes.CELESTIAL_PLANKS, EnderscapeSoundTypes.CELESTIAL_HANGING_SIGN, EnderscapeBlockSounds.CELESTIAL_FENCE_GATE_CLOSE, EnderscapeBlockSounds.CELESTIAL_FENCE_GATE_OPEN);
    public static final WoodType MURUBLIGHT_WOOD_TYPE = EnderscapeBlocks.registerWoodType(Enderscape.id("murublight"), MURUBLIGHT_BLOCK_SET, EnderscapeSoundTypes.MURUBLIGHT_PLANKS, EnderscapeSoundTypes.MURUBLIGHT_HANGING_SIGN, EnderscapeBlockSounds.MURUBLIGHT_FENCE_GATE_CLOSE, EnderscapeBlockSounds.MURUBLIGHT_FENCE_GATE_OPEN);
    public static final Supplier<Block> DRIFT_JELLY_BLOCK = EnderscapeBlocks.register(true, "drift_jelly_block", DriftJellyBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_WART_BLOCK).instabreak().sound(EnderscapeSoundTypes.DRIFT_JELLY_BLOCK).noOcclusion());
    public static final Supplier<Block> END_TRIAL_SPAWNER = EnderscapeBlocks.register(true, "end_trial_spawner", TrialSpawnerBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.TRIAL_SPAWNER));
    public static final Supplier<Block> END_VAULT = EnderscapeBlocks.register(true, "end_vault", EndVaultBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.VAULT, p -> p.sound(EnderscapeSoundTypes.END_VAULT)));
    public static final Supplier<Block> END_STONE_STAIRS = EnderscapeBlocks.registerStair("end_stone_stairs", () -> Blocks.END_STONE);
    public static final Supplier<Block> END_STONE_SLAB = EnderscapeBlocks.register(true, "end_stone_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(Blocks.END_STONE));
    public static final Supplier<Block> END_STONE_WALL = EnderscapeBlocks.register(true, "end_stone_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(Blocks.END_STONE));
    public static final Supplier<Block> POLISHED_END_STONE = EnderscapeBlocks.register(true, "polished_end_stone", Block::new, EnderscapeBlocks.legacyCopyOf(Blocks.END_STONE, p -> p.sound(SoundType.STONE)));
    public static final Supplier<Block> POLISHED_END_STONE_STAIRS = EnderscapeBlocks.registerStair("polished_end_stone_stairs", POLISHED_END_STONE);
    public static final Supplier<Block> POLISHED_END_STONE_SLAB = EnderscapeBlocks.register(true, "polished_end_stone_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_END_STONE));
    public static final Supplier<Block> POLISHED_END_STONE_WALL = EnderscapeBlocks.register(true, "polished_end_stone_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_END_STONE));
    public static final Supplier<Block> POLISHED_END_STONE_BUTTON = EnderscapeBlocks.register(true, "polished_end_stone_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(POLISHED_END_STONE_BLOCK_SET, 20, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> POLISHED_END_STONE_PRESSURE_PLATE = EnderscapeBlocks.register(true, "polished_end_stone_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(POLISHED_END_STONE_BLOCK_SET, properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.STONE).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> CHISELED_END_STONE = EnderscapeBlocks.register(true, "chiseled_end_stone", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_END_STONE, p -> p.sound(SoundType.STONE)));
    public static final Supplier<Block> MIRESTONE = EnderscapeBlocks.register(true, "mirestone", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(6.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.MIRESTONE));
    public static final Supplier<Block> MIRESTONE_STAIRS = EnderscapeBlocks.registerStair("mirestone_stairs", MIRESTONE);
    public static final Supplier<Block> MIRESTONE_SLAB = EnderscapeBlocks.register(true, "mirestone_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(MIRESTONE));
    public static final Supplier<Block> MIRESTONE_WALL = EnderscapeBlocks.register(true, "mirestone_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(MIRESTONE));
    public static final Supplier<Block> POLISHED_MIRESTONE = EnderscapeBlocks.register(true, "polished_mirestone", Block::new, EnderscapeBlocks.legacyCopyOf(MIRESTONE));
    public static final Supplier<Block> POLISHED_MIRESTONE_STAIRS = EnderscapeBlocks.registerStair("polished_mirestone_stairs", POLISHED_MIRESTONE);
    public static final Supplier<Block> POLISHED_MIRESTONE_SLAB = EnderscapeBlocks.register(true, "polished_mirestone_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_MIRESTONE));
    public static final Supplier<Block> POLISHED_MIRESTONE_WALL = EnderscapeBlocks.register(true, "polished_mirestone_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_MIRESTONE));
    public static final Supplier<Block> POLISHED_MIRESTONE_BUTTON = EnderscapeBlocks.register(true, "polished_mirestone_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(POLISHED_MIRESTONE_BLOCK_SET, 20, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> POLISHED_MIRESTONE_PRESSURE_PLATE = EnderscapeBlocks.register(true, "polished_mirestone_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(POLISHED_MIRESTONE_BLOCK_SET, properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.MIRESTONE).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> MIRESTONE_BRICKS = EnderscapeBlocks.register(true, "mirestone_bricks", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_MIRESTONE, p -> p.sound(EnderscapeSoundTypes.MIRESTONE_BRICKS)));
    public static final Supplier<Block> MIRESTONE_BRICK_STAIRS = EnderscapeBlocks.registerStair("mirestone_brick_stairs", MIRESTONE_BRICKS);
    public static final Supplier<Block> MIRESTONE_BRICK_SLAB = EnderscapeBlocks.register(true, "mirestone_brick_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(MIRESTONE_BRICKS));
    public static final Supplier<Block> MIRESTONE_BRICK_WALL = EnderscapeBlocks.register(true, "mirestone_brick_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(MIRESTONE_BRICKS));
    public static final Supplier<Block> CHISELED_MIRESTONE = EnderscapeBlocks.register(true, "chiseled_mirestone", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_MIRESTONE, p -> p.sound(EnderscapeSoundTypes.MIRESTONE_BRICKS)));
    public static final Supplier<Block> VERADITE = EnderscapeBlocks.register(true, "veradite", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).requiresCorrectToolForDrops().strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.VERADITE));
    public static final Supplier<Block> VERADITE_STAIRS = EnderscapeBlocks.registerStair("veradite_stairs", VERADITE);
    public static final Supplier<Block> VERADITE_SLAB = EnderscapeBlocks.register(true, "veradite_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(VERADITE));
    public static final Supplier<Block> VERADITE_WALL = EnderscapeBlocks.register(true, "veradite_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(VERADITE));
    public static final Supplier<Block> POLISHED_VERADITE = EnderscapeBlocks.register(true, "polished_veradite", Block::new, EnderscapeBlocks.legacyCopyOf(VERADITE));
    public static final Supplier<Block> POLISHED_VERADITE_STAIRS = EnderscapeBlocks.registerStair("polished_veradite_stairs", POLISHED_VERADITE);
    public static final Supplier<Block> POLISHED_VERADITE_SLAB = EnderscapeBlocks.register(true, "polished_veradite_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_VERADITE));
    public static final Supplier<Block> POLISHED_VERADITE_WALL = EnderscapeBlocks.register(true, "polished_veradite_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_VERADITE));
    public static final Supplier<Block> POLISHED_VERADITE_BUTTON = EnderscapeBlocks.register(true, "polished_veradite_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(POLISHED_VERADITE_BLOCK_SET, 20, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> POLISHED_VERADITE_PRESSURE_PLATE = EnderscapeBlocks.register(true, "polished_veradite_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(POLISHED_VERADITE_BLOCK_SET, properties), BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.VERADITE).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> VERADITE_BRICKS = EnderscapeBlocks.register(true, "veradite_bricks", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_VERADITE, p -> p.sound(EnderscapeSoundTypes.VERADITE_BRICKS)));
    public static final Supplier<Block> VERADITE_BRICK_STAIRS = EnderscapeBlocks.registerStair("veradite_brick_stairs", VERADITE_BRICKS);
    public static final Supplier<Block> VERADITE_BRICK_SLAB = EnderscapeBlocks.register(true, "veradite_brick_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(VERADITE_BRICKS));
    public static final Supplier<Block> VERADITE_BRICK_WALL = EnderscapeBlocks.register(true, "veradite_brick_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(VERADITE_BRICKS));
    public static final Supplier<Block> CHISELED_VERADITE = EnderscapeBlocks.register(true, "chiseled_veradite", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_VERADITE, p -> p.sound(EnderscapeSoundTypes.VERADITE_BRICKS)));
    public static final Supplier<Block> KURODITE = EnderscapeBlocks.register(true, "kurodite", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).requiresCorrectToolForDrops().strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.KURODITE));
    public static final Supplier<Block> KURODITE_STAIRS = EnderscapeBlocks.registerStair("kurodite_stairs", KURODITE);
    public static final Supplier<Block> KURODITE_SLAB = EnderscapeBlocks.register(true, "kurodite_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(KURODITE));
    public static final Supplier<Block> KURODITE_WALL = EnderscapeBlocks.register(true, "kurodite_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(KURODITE));
    public static final Supplier<Block> POLISHED_KURODITE = EnderscapeBlocks.register(true, "polished_kurodite", Block::new, EnderscapeBlocks.legacyCopyOf(KURODITE));
    public static final Supplier<Block> POLISHED_KURODITE_STAIRS = EnderscapeBlocks.registerStair("polished_kurodite_stairs", POLISHED_KURODITE);
    public static final Supplier<Block> POLISHED_KURODITE_SLAB = EnderscapeBlocks.register(true, "polished_kurodite_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_KURODITE));
    public static final Supplier<Block> POLISHED_KURODITE_WALL = EnderscapeBlocks.register(true, "polished_kurodite_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(POLISHED_KURODITE));
    public static final Supplier<Block> POLISHED_KURODITE_BUTTON = EnderscapeBlocks.register(true, "polished_kurodite_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(POLISHED_KURODITE_BLOCK_SET, 20, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> POLISHED_KURODITE_PRESSURE_PLATE = EnderscapeBlocks.register(true, "polished_kurodite_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(POLISHED_KURODITE_BLOCK_SET, properties), BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.KURODITE).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> KURODITE_BRICKS = EnderscapeBlocks.register(true, "kurodite_bricks", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_KURODITE, p -> p.sound(EnderscapeSoundTypes.KURODITE_BRICKS)));
    public static final Supplier<Block> KURODITE_BRICK_STAIRS = EnderscapeBlocks.registerStair("kurodite_brick_stairs", KURODITE_BRICKS);
    public static final Supplier<Block> KURODITE_BRICK_SLAB = EnderscapeBlocks.register(true, "kurodite_brick_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(KURODITE_BRICKS));
    public static final Supplier<Block> KURODITE_BRICK_WALL = EnderscapeBlocks.register(true, "kurodite_brick_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(KURODITE_BRICKS));
    public static final Supplier<Block> CHISELED_KURODITE = EnderscapeBlocks.register(true, "chiseled_kurodite", Block::new, EnderscapeBlocks.legacyCopyOf(POLISHED_KURODITE, p -> p.sound(EnderscapeSoundTypes.KURODITE_BRICKS)));
    public static final Supplier<Block> VOID_SHALE = EnderscapeBlocks.register(true, "void_shale", VoidShaleBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.5f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.VOID_SHALE));
    public static final Supplier<Block> ALLURING_MAGNIA = EnderscapeBlocks.register(true, "alluring_magnia", AlluringMagniaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.ALLURING_MAGNIA));
    public static final Supplier<Block> ALLURING_MAGNIA_SPROUT = EnderscapeBlocks.register(true, "alluring_magnia_sprout", AlluringMagniaSproutBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).lightLevel(state -> (Boolean)state.getValue((Property)MagniaSproutBlock.POWERED) != false ? 12 : 0).requiresCorrectToolForDrops().noOcclusion().strength(1.0f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.ALLURING_MAGNIA));
    public static final Supplier<Block> ETCHED_ALLURING_MAGNIA = EnderscapeBlocks.register(true, "etched_alluring_magnia", Block::new, EnderscapeBlocks.legacyCopyOf(ALLURING_MAGNIA));
    public static final Supplier<Block> REPULSIVE_MAGNIA = EnderscapeBlocks.register(true, "repulsive_magnia", RepulsiveMagniaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.REPULSIVE_MAGNIA));
    public static final Supplier<Block> REPULSIVE_MAGNIA_SPROUT = EnderscapeBlocks.register(true, "repulsive_magnia_sprout", RepulsiveMagniaSproutBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).lightLevel(state -> (Boolean)state.getValue((Property)MagniaSproutBlock.POWERED) != false ? 12 : 0).requiresCorrectToolForDrops().noOcclusion().strength(1.0f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.REPULSIVE_MAGNIA));
    public static final Supplier<Block> ETCHED_REPULSIVE_MAGNIA = EnderscapeBlocks.register(true, "etched_repulsive_magnia", Block::new, EnderscapeBlocks.legacyCopyOf(REPULSIVE_MAGNIA));
    public static final Supplier<Block> SHADOLINE_ORE = EnderscapeBlocks.register(true, "shadoline_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), EnderscapeBlocks.fullCopyOf(Blocks.END_STONE, p -> p.sound(EnderscapeSoundTypes.SHADOLINE_ORE)));
    public static final Supplier<Block> MIRESTONE_SHADOLINE_ORE = EnderscapeBlocks.register(true, "mirestone_shadoline_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), EnderscapeBlocks.fullCopyOf(MIRESTONE, p -> p.sound(EnderscapeSoundTypes.MIRESTONE_SHADOLINE_ORE)));
    public static final Supplier<Block> RAW_SHADOLINE_BLOCK = EnderscapeBlocks.register(true, "raw_shadoline_block", Block::new, EnderscapeBlocks.fullCopyOf(Blocks.RAW_IRON_BLOCK, p -> p.mapColor(MapColor.COLOR_LIGHT_GRAY).strength(3.0f).sound(EnderscapeSoundTypes.SHADOLINE_ORE).instrument(EnderscapeNoteBlockInstruments.SYNTH_BASS.get())));
    public static final Supplier<Block> SHADOLINE_BLOCK = EnderscapeBlocks.register(true, "shadoline_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GREEN).requiresCorrectToolForDrops().strength(3.0f, 9.0f).sound(EnderscapeSoundTypes.SHADOLINE).instrument(EnderscapeNoteBlockInstruments.SYNTH_BASS.get()));
    public static final Supplier<Block> SHADOLINE_BLOCK_STAIRS = EnderscapeBlocks.registerStair("shadoline_block_stairs", SHADOLINE_BLOCK);
    public static final Supplier<Block> SHADOLINE_BLOCK_SLAB = EnderscapeBlocks.register(true, "shadoline_block_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(SHADOLINE_BLOCK));
    public static final Supplier<Block> SHADOLINE_BLOCK_WALL = EnderscapeBlocks.register(true, "shadoline_block_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(SHADOLINE_BLOCK));
    public static final Supplier<Block> CUT_SHADOLINE = EnderscapeBlocks.register(true, "cut_shadoline", Block::new, EnderscapeBlocks.legacyCopyOf(SHADOLINE_BLOCK, p -> p.sound(EnderscapeSoundTypes.CUT_SHADOLINE)));
    public static final Supplier<Block> CUT_SHADOLINE_STAIRS = EnderscapeBlocks.registerStair("cut_shadoline_stairs", CUT_SHADOLINE);
    public static final Supplier<Block> CUT_SHADOLINE_SLAB = EnderscapeBlocks.register(true, "cut_shadoline_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(CUT_SHADOLINE));
    public static final Supplier<Block> CUT_SHADOLINE_WALL = EnderscapeBlocks.register(true, "cut_shadoline_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(CUT_SHADOLINE));
    public static final Supplier<Block> CHISELED_SHADOLINE = EnderscapeBlocks.register(true, "chiseled_shadoline", Block::new, EnderscapeBlocks.legacyCopyOf(CUT_SHADOLINE));
    public static final Supplier<Block> SHADOLINE_PILLAR = EnderscapeBlocks.register(true, "shadoline_pillar", RotatedPillarBlock::new, EnderscapeBlocks.legacyCopyOf(SHADOLINE_BLOCK));
    public static final Supplier<Block> NEBULITE_ORE = EnderscapeBlocks.register(true, "nebulite_ore", NebuliteOreBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.END_STONE, p -> p.sound(EnderscapeSoundTypes.NEBULITE_ORE).randomTicks()));
    public static final Supplier<Block> MIRESTONE_NEBULITE_ORE = EnderscapeBlocks.register(true, "mirestone_nebulite_ore", NebuliteOreBlock::new, EnderscapeBlocks.fullCopyOf(MIRESTONE, p -> p.sound(EnderscapeSoundTypes.MIRESTONE_NEBULITE_ORE).randomTicks()));
    public static final Supplier<Block> NEBULITE_BLOCK = EnderscapeBlocks.register(true, "nebulite_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(EnderscapeSoundTypes.NEBULITE_BLOCK).instrument(EnderscapeNoteBlockInstruments.SYNTH_BELL.get()));
    public static final Supplier<Block> DRY_END_GROWTH = EnderscapeBlocks.register(true, "dry_end_growth", DryEndGrowthBlock::new, BlockBehaviour.Properties.of().instabreak().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.SAND).noCollission().noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).replaceable().sound(EnderscapeSoundTypes.DRY_END_GROWTH));
    public static final Supplier<Block> CHORUS_SPROUTS = EnderscapeBlocks.register(true, "chorus_sprouts", ChorusSproutsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noCollission().instabreak().instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.CHORUS_SPROUTS).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ));
    public static final Supplier<Block> PURPUR_WALL = EnderscapeBlocks.register(true, "purpur_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(Blocks.PURPUR_BLOCK));
    public static final Supplier<Block> CHISELED_PURPUR = EnderscapeBlocks.register(true, "chiseled_purpur", Block::new, EnderscapeBlocks.legacyCopyOf(Blocks.PURPUR_BLOCK));
    public static final Supplier<Block> DUSK_PURPUR_BLOCK = EnderscapeBlocks.register(true, "dusk_purpur_block", Block::new, EnderscapeBlocks.fullCopyOf(Blocks.PURPUR_BLOCK, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> DUSK_PURPUR_STAIRS = EnderscapeBlocks.registerStair("dusk_purpur_stairs", DUSK_PURPUR_BLOCK);
    public static final Supplier<Block> DUSK_PURPUR_SLAB = EnderscapeBlocks.register(true, "dusk_purpur_slab", SlabBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.PURPUR_SLAB, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> DUSK_PURPUR_WALL = EnderscapeBlocks.register(true, "dusk_purpur_wall", WallBlock::new, EnderscapeBlocks.fullCopyOf(PURPUR_WALL, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> CHISELED_DUSK_PURPUR = EnderscapeBlocks.register(true, "chiseled_dusk_purpur", Block::new, EnderscapeBlocks.fullCopyOf(CHISELED_PURPUR, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> DUSK_PURPUR_PILLAR = EnderscapeBlocks.register(true, "dusk_purpur_pillar", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.PURPUR_PILLAR, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> PURPUR_TILES = EnderscapeBlocks.register(true, "purpur_tiles", Block::new, EnderscapeBlocks.fullCopyOf(Blocks.PURPUR_BLOCK));
    public static final Supplier<Block> PURPUR_TILE_STAIRS = EnderscapeBlocks.registerStair("purpur_tile_stairs", PURPUR_TILES);
    public static final Supplier<Block> PURPUR_TILE_SLAB = EnderscapeBlocks.register(true, "purpur_tile_slab", SlabBlock::new, EnderscapeBlocks.fullCopyOf(Blocks.PURPUR_SLAB));
    public static final Supplier<Block> CHORUS_CAKE_ROLL = EnderscapeBlocks.register(false, "chorus_cake_roll", ChorusCakeRollBlock::new, BlockBehaviour.Properties.of().forceSolidOn().strength(0.5f).sound(EnderscapeSoundTypes.CHORUS_CAKE_ROLL).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> END_LAMP = EnderscapeBlocks.register(true, "end_lamp", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.PLING).strength(0.6f).sound(EnderscapeSoundTypes.END_LAMP).lightLevel(state -> 15).isRedstoneConductor(EnderscapeBlocks::never));
    public static final Supplier<Block> VEILED_END_STONE = EnderscapeBlocks.register(true, "veiled_end_stone", VeiledOvergrowthBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).requiresCorrectToolForDrops().strength(3.0f, 9.0f).sound(EnderscapeSoundTypes.VEILED_END_STONE).randomTicks().isValidSpawn(Blocks::always));
    public static final Supplier<Block> WISP_SPROUTS = EnderscapeBlocks.register(true, "wisp_sprouts", WispSproutsBlock::new, BlockBehaviour.Properties.of().instabreak().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.CLAY).noCollission().noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).replaceable().sound(EnderscapeSoundTypes.WISP_GROWTH));
    public static final Supplier<Block> WISP_GROWTH = EnderscapeBlocks.register(true, "wisp_growth", WispGrowthBlock::new, BlockBehaviour.Properties.of().instabreak().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.CLAY).noCollission().noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).replaceable().sound(EnderscapeSoundTypes.WISP_GROWTH));
    public static final Supplier<Block> WISP_FLOWER = EnderscapeBlocks.register(true, "wisp_flower", WispFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).noCollission().instabreak().sound(EnderscapeSoundTypes.WISP_FLOWER).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().lightLevel(state -> 7).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> STRIPPED_VEILED_LOG = EnderscapeBlocks.register(true, "stripped_veiled_log", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f).sound(EnderscapeSoundTypes.VEILED_LOG));
    public static final Supplier<Block> VEILED_LOG = EnderscapeBlocks.register(true, "veiled_log", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_VEILED_LOG, p -> p.mapColor(MapColor.TERRACOTTA_LIGHT_BLUE)));
    public static final Supplier<Block> STRIPPED_VEILED_WOOD = EnderscapeBlocks.register(true, "stripped_veiled_wood", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_VEILED_LOG));
    public static final Supplier<Block> VEILED_WOOD = EnderscapeBlocks.register(true, "veiled_wood", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_VEILED_WOOD, p -> p.mapColor(MapColor.TERRACOTTA_LIGHT_BLUE)));
    public static final Supplier<Block> VEILED_LEAVES = EnderscapeBlocks.register(true, "veiled_leaves", VeiledLeavesBlock::new, EnderscapeBlocks.leavesProperties(EnderscapeSoundTypes.VEILED_LEAVES).mapColor(MapColor.CLAY));
    public static final Supplier<Block> VEILED_LEAF_PILE = EnderscapeBlocks.register(true, "veiled_leaf_pile", VeiledLeafPileBlock::new, BlockBehaviour.Properties.of().forceSolidOff().ignitedByLava().isRedstoneConductor(EnderscapeBlocks::never).isSuffocating(EnderscapeBlocks::never).isValidSpawn(Blocks::ocelotOrParrot).isViewBlocking(EnderscapeBlocks::never).mapColor(MapColor.CLAY).noOcclusion().pushReaction(PushReaction.DESTROY).randomTicks().replaceable().sound(EnderscapeSoundTypes.VEILED_LEAVES).strength(0.1f));
    public static final Supplier<Block> VEILED_VINES = EnderscapeBlocks.register(true, "veiled_vines", VeiledVinesBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).noCollission().noOcclusion().pushReaction(PushReaction.DESTROY).sound(EnderscapeSoundTypes.VEILED_LEAVES).strength(0.2f));
    public static final Supplier<Block> VEILED_SAPLING = EnderscapeBlocks.register(true, "veiled_sapling", (BlockBehaviour.Properties properties) -> new VeiledSaplingBlock(EnderscapeConfiguredFeatures.VEILED_TREE_FROM_SAPLING, (BlockBehaviour.Properties)properties), EnderscapeBlocks.fullCopyOf(Blocks.OAK_SAPLING, p -> p.mapColor(MapColor.CLAY).sound(EnderscapeSoundTypes.CHORUS_SPROUTS)));
    public static final Supplier<Block> VEILED_PLANKS = EnderscapeBlocks.register(true, "veiled_planks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f, 3.0f).sound(EnderscapeSoundTypes.VEILED_PLANKS));
    public static final Supplier<Block> VEILED_STAIRS = EnderscapeBlocks.registerStair("veiled_stairs", VEILED_PLANKS);
    public static final Supplier<Block> VEILED_SLAB = EnderscapeBlocks.register(true, "veiled_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(VEILED_PLANKS));
    public static final Supplier<Block> VEILED_PRESSURE_PLATE = EnderscapeBlocks.register(true, "veiled_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(VEILED_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(VEILED_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> VEILED_FENCE = EnderscapeBlocks.register(true, "veiled_fence", FenceBlock::new, EnderscapeBlocks.legacyCopyOf(VEILED_PLANKS));
    public static final Supplier<Block> VEILED_DOOR = EnderscapeBlocks.register(true, "veiled_door", (BlockBehaviour.Properties properties) -> new DoorBlock(VEILED_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(VEILED_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> VEILED_TRAPDOOR = EnderscapeBlocks.register(true, "veiled_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(VEILED_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(VEILED_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Supplier<Block> VEILED_FENCE_GATE = EnderscapeBlocks.register(true, "veiled_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(VEILED_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(VEILED_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Supplier<Block> VEILED_BUTTON = EnderscapeBlocks.register(true, "veiled_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(VEILED_BLOCK_SET, 30, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> VEILED_SIGN = EnderscapeBlocks.register(false, "veiled_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(VEILED_WOOD_TYPE, properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> VEILED_WALL_SIGN = EnderscapeBlocks.register(false, "veiled_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(VEILED_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(VEILED_SIGN, p -> p.mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> VEILED_HANGING_SIGN = EnderscapeBlocks.register(false, "veiled_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(VEILED_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(VEILED_LOG.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> VEILED_WALL_HANGING_SIGN = EnderscapeBlocks.register(false, "veiled_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(VEILED_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(VEILED_HANGING_SIGN, p -> p.mapColor(VEILED_LOG.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> CELESTIAL_PATH_BLOCK = EnderscapeBlocks.register(true, "celestial_path_block", CelestialPathBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(3.0f, 9.0f).sound(EnderscapeSoundTypes.CELESTIAL_OVERGROWTH).isViewBlocking(EnderscapeBlocks::always).isSuffocating(EnderscapeBlocks::always));
    public static final Supplier<Block> CELESTIAL_OVERGROWTH = EnderscapeBlocks.register(true, "celestial_overgrowth", CelestialOvergrowthBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).requiresCorrectToolForDrops().strength(3.0f, 9.0f).sound(EnderscapeSoundTypes.CELESTIAL_OVERGROWTH).randomTicks().isValidSpawn(Blocks::always));
    public static final Supplier<Block> CELESTIAL_GROWTH = EnderscapeBlocks.register(true, "celestial_growth", CelestialGrowthBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).noCollission().instabreak().sound(EnderscapeSoundTypes.CELESTIAL_GROWTH).noOcclusion());
    public static final Supplier<Block> BULB_FLOWER = EnderscapeBlocks.register(true, "bulb_flower", BulbFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollission().instabreak().sound(EnderscapeSoundTypes.BULB_FLOWER).noOcclusion().lightLevel(state -> 7));
    public static final Supplier<Block> BULB_LANTERN = EnderscapeBlocks.register(true, "bulb_lantern", BulbLanternBlock::new, EnderscapeBlocks.legacyCopyOf(Blocks.LANTERN, p -> p.sound(EnderscapeSoundTypes.BULB_LANTERN)));
    public static final Supplier<Block> FLANGER_BERRY_VINE = EnderscapeBlocks.register(false, "flanger_berry_vine", FlangerBerryVine::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).randomTicks().noCollission().sound(EnderscapeSoundTypes.FLANGER_BERRY_VINE).strength(0.2f));
    public static final Supplier<Block> FLANGER_BERRY_FLOWER = EnderscapeBlocks.register(true, "flanger_berry_flower", FlangerBerryFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_WART_BLOCK).randomTicks().strength(0.3f).pushReaction(PushReaction.DESTROY).noCollission().sound(EnderscapeSoundTypes.FLANGER_FLOWER).noOcclusion());
    public static final Supplier<Block> UNRIPE_FLANGER_BERRY_BLOCK = EnderscapeBlocks.register(true, "unripe_flanger_berry_block", UnripeFlangerBerryBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_WART_BLOCK).randomTicks().strength(0.3f).pushReaction(PushReaction.DESTROY).sound(EnderscapeSoundTypes.FLANGER_BERRY_BLOCK).noOcclusion());
    public static final Supplier<Block> RIPE_FLANGER_BERRY_BLOCK = EnderscapeBlocks.register(true, "ripe_flanger_berry_block", RipeFlangerBerryBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_WART_BLOCK).strength(0.3f).pushReaction(PushReaction.DESTROY).sound(EnderscapeSoundTypes.FLANGER_BERRY_BLOCK));
    public static final Supplier<Block> CELESTIAL_CHANTERELLE = EnderscapeBlocks.register(true, "celestial_chanterelle", (BlockBehaviour.Properties properties) -> new CelestialChanterelleBlock(EnderscapeConfiguredFeatures.LARGE_CELESTIAL_CHANTERELLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).noCollission().instabreak().randomTicks().sound(EnderscapeSoundTypes.CELESTIAL_CHANTERELLE));
    public static final Supplier<Block> STRIPPED_CELESTIAL_STEM = EnderscapeBlocks.register(true, "stripped_celestial_stem", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(2.0f).sound(EnderscapeSoundTypes.CELESTIAL_STEM));
    public static final Supplier<Block> CELESTIAL_STEM = EnderscapeBlocks.register(true, "celestial_stem", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_CELESTIAL_STEM, p -> p.mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final Supplier<Block> STRIPPED_CELESTIAL_HYPHAE = EnderscapeBlocks.register(true, "stripped_celestial_hyphae", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_CELESTIAL_STEM));
    public static final Supplier<Block> CELESTIAL_HYPHAE = EnderscapeBlocks.register(true, "celestial_hyphae", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_CELESTIAL_HYPHAE, p -> p.mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final Supplier<Block> CELESTIAL_CAP = EnderscapeBlocks.register(true, "celestial_cap", ChanterelleCapBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).strength(1.0f).sound(EnderscapeSoundTypes.CELESTIAL_CAP).isValidSpawn(Blocks::never));
    public static final Supplier<Block> CELESTIAL_BRICKS = EnderscapeBlocks.register(true, "celestial_bricks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).strength(1.5f, 6.0f).sound(EnderscapeSoundTypes.CELESTIAL_BRICKS));
    public static final Supplier<Block> CELESTIAL_BRICK_STAIRS = EnderscapeBlocks.registerStair("celestial_brick_stairs", CELESTIAL_BRICKS);
    public static final Supplier<Block> CELESTIAL_BRICK_SLAB = EnderscapeBlocks.register(true, "celestial_brick_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(CELESTIAL_BRICKS));
    public static final Supplier<Block> CELESTIAL_BRICK_WALL = EnderscapeBlocks.register(true, "celestial_brick_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(CELESTIAL_BRICKS));
    public static final Supplier<Block> CELESTIAL_PLANKS = EnderscapeBlocks.register(true, "celestial_planks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(2.0f, 3.0f).sound(EnderscapeSoundTypes.CELESTIAL_PLANKS));
    public static final Supplier<Block> CELESTIAL_STAIRS = EnderscapeBlocks.registerStair("celestial_stairs", CELESTIAL_PLANKS);
    public static final Supplier<Block> CELESTIAL_SLAB = EnderscapeBlocks.register(true, "celestial_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(CELESTIAL_PLANKS));
    public static final Supplier<Block> CELESTIAL_PRESSURE_PLATE = EnderscapeBlocks.register(true, "celestial_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(CELESTIAL_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(CELESTIAL_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> CELESTIAL_FENCE = EnderscapeBlocks.register(true, "celestial_fence", FenceBlock::new, EnderscapeBlocks.legacyCopyOf(CELESTIAL_PLANKS));
    public static final Supplier<Block> CELESTIAL_DOOR = EnderscapeBlocks.register(true, "celestial_door", (BlockBehaviour.Properties properties) -> new DoorBlock(CELESTIAL_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(CELESTIAL_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> CELESTIAL_TRAPDOOR = EnderscapeBlocks.register(true, "celestial_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(CELESTIAL_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(CELESTIAL_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Supplier<Block> CELESTIAL_FENCE_GATE = EnderscapeBlocks.register(true, "celestial_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(CELESTIAL_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(CELESTIAL_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Supplier<Block> CELESTIAL_BUTTON = EnderscapeBlocks.register(true, "celestial_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(CELESTIAL_BLOCK_SET, 30, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> CELESTIAL_SIGN = EnderscapeBlocks.register(false, "celestial_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(CELESTIAL_WOOD_TYPE, properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> CELESTIAL_WALL_SIGN = EnderscapeBlocks.register(false, "celestial_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(CELESTIAL_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(CELESTIAL_SIGN, p -> p.mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> CELESTIAL_HANGING_SIGN = EnderscapeBlocks.register(false, "celestial_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(CELESTIAL_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(CELESTIAL_STEM.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> CELESTIAL_WALL_HANGING_SIGN = EnderscapeBlocks.register(false, "celestial_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(CELESTIAL_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(CELESTIAL_HANGING_SIGN, p -> p.mapColor(CELESTIAL_STEM.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> CORRUPT_PATH_BLOCK = EnderscapeBlocks.register(true, "corrupt_path_block", CorruptPathBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().strength(3.0f, 9.0f).sound(EnderscapeSoundTypes.CORRUPT_OVERGROWTH).isSuffocating(EnderscapeBlocks::always));
    public static final Supplier<Block> CORRUPT_OVERGROWTH = EnderscapeBlocks.register(true, "corrupt_overgrowth", CorruptOvergrowthBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().strength(6.0f, 9.0f).sound(EnderscapeSoundTypes.CORRUPT_OVERGROWTH).isValidSpawn(Blocks::always));
    public static final Supplier<Block> CORRUPT_GROWTH = EnderscapeBlocks.register(true, "corrupt_growth", CorruptGrowthBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noCollission().instabreak().sound(EnderscapeSoundTypes.CORRUPT_GROWTH).noOcclusion());
    public static final Supplier<Block> BLINKLIGHT_VINES_BODY = EnderscapeBlocks.register(false, "blinklight_vines_body", BlinklightVinesBodyBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).noCollission().sound(EnderscapeSoundTypes.BLINKLIGHT_VINES).strength(0.8f).randomTicks().lightLevel(BlinklightVines::getLuminance));
    public static final Supplier<Block> BLINKLIGHT_VINES_HEAD = EnderscapeBlocks.register(false, "blinklight_vines_head", BlinklightVinesHeadBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).noCollission().sound(EnderscapeSoundTypes.BLINKLIGHT_VINES).strength(0.8f).randomTicks().lightLevel(BlinklightVines::getLuminance));
    public static final Supplier<Block> BLINKLAMP = EnderscapeBlocks.register(true, "blinklamp", BlinklampBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).sound(EnderscapeSoundTypes.BLINKLAMP));
    public static final Supplier<Block> MURUBLIGHT_SHELF = EnderscapeBlocks.register(false, "murublight_shelf", MurublightShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).noCollission().instabreak().sound(EnderscapeSoundTypes.MURUBLIGHT_SHELF).noOcclusion());
    public static final Supplier<Block> MURUBLIGHT_CHANTERELLE = EnderscapeBlocks.register(true, "murublight_chanterelle", MurublightChanterelleBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).noCollission().instabreak().randomTicks().sound(EnderscapeSoundTypes.CELESTIAL_CHANTERELLE));
    public static final Supplier<Block> STRIPPED_MURUBLIGHT_STEM = EnderscapeBlocks.register(true, "stripped_murublight_stem", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).strength(2.0f).sound(EnderscapeSoundTypes.MURUBLIGHT_STEM));
    public static final Supplier<Block> MURUBLIGHT_STEM = EnderscapeBlocks.register(true, "murublight_stem", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_MURUBLIGHT_STEM, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> STRIPPED_MURUBLIGHT_HYPHAE = EnderscapeBlocks.register(true, "stripped_murublight_hyphae", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_MURUBLIGHT_STEM));
    public static final Supplier<Block> MURUBLIGHT_HYPHAE = EnderscapeBlocks.register(true, "murublight_hyphae", RotatedPillarBlock::new, EnderscapeBlocks.fullCopyOf(STRIPPED_MURUBLIGHT_HYPHAE, p -> p.mapColor(MapColor.COLOR_BLACK)));
    public static final Supplier<Block> MURUBLIGHT_CAP = EnderscapeBlocks.register(true, "murublight_cap", ChanterelleCapBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).strength(1.0f).sound(EnderscapeSoundTypes.MURUBLIGHT_CAP).isValidSpawn(Blocks::never));
    public static final Supplier<Block> MURUBLIGHT_BRICKS = EnderscapeBlocks.register(true, "murublight_bricks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).strength(1.5f, 6.0f).sound(EnderscapeSoundTypes.MURUBLIGHT_BRICKS));
    public static final Supplier<Block> MURUBLIGHT_BRICK_STAIRS = EnderscapeBlocks.registerStair("murublight_brick_stairs", MURUBLIGHT_BRICKS);
    public static final Supplier<Block> MURUBLIGHT_BRICK_SLAB = EnderscapeBlocks.register(true, "murublight_brick_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(MURUBLIGHT_BRICKS));
    public static final Supplier<Block> MURUBLIGHT_BRICK_WALL = EnderscapeBlocks.register(true, "murublight_brick_wall", WallBlock::new, EnderscapeBlocks.legacyCopyOf(MURUBLIGHT_BRICKS));
    public static final Supplier<Block> MURUBLIGHT_PLANKS = EnderscapeBlocks.register(true, "murublight_planks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).strength(2.0f, 3.0f).sound(EnderscapeSoundTypes.MURUBLIGHT_PLANKS));
    public static final Supplier<Block> MURUBLIGHT_STAIRS = EnderscapeBlocks.registerStair("murublight_stairs", MURUBLIGHT_PLANKS);
    public static final Supplier<Block> MURUBLIGHT_SLAB = EnderscapeBlocks.register(true, "murublight_slab", SlabBlock::new, EnderscapeBlocks.legacyCopyOf(MURUBLIGHT_PLANKS));
    public static final Supplier<Block> MURUBLIGHT_PRESSURE_PLATE = EnderscapeBlocks.register(true, "murublight_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(MURUBLIGHT_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(MURUBLIGHT_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> MURUBLIGHT_FENCE = EnderscapeBlocks.register(true, "murublight_fence", FenceBlock::new, EnderscapeBlocks.legacyCopyOf(MURUBLIGHT_PLANKS));
    public static final Supplier<Block> MURUBLIGHT_DOOR = EnderscapeBlocks.register(true, "murublight_door", (BlockBehaviour.Properties properties) -> new DoorBlock(MURUBLIGHT_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(MURUBLIGHT_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> MURUBLIGHT_TRAPDOOR = EnderscapeBlocks.register(true, "murublight_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(MURUBLIGHT_BLOCK_SET, properties), () -> BlockBehaviour.Properties.of().mapColor(MURUBLIGHT_PLANKS.get().defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Supplier<Block> MURUBLIGHT_FENCE_GATE = EnderscapeBlocks.register(true, "murublight_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(MURUBLIGHT_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(MURUBLIGHT_PLANKS.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Supplier<Block> MURUBLIGHT_BUTTON = EnderscapeBlocks.register(true, "murublight_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(MURUBLIGHT_BLOCK_SET, 30, properties), EnderscapeBlocks.buttonProperties());
    public static final Supplier<Block> MURUBLIGHT_SIGN = EnderscapeBlocks.register(false, "murublight_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(MURUBLIGHT_WOOD_TYPE, properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> MURUBLIGHT_WALL_SIGN = EnderscapeBlocks.register(false, "murublight_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(MURUBLIGHT_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(MURUBLIGHT_SIGN, p -> p.mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> MURUBLIGHT_HANGING_SIGN = EnderscapeBlocks.register(false, "murublight_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(MURUBLIGHT_WOOD_TYPE, properties), () -> BlockBehaviour.Properties.of().mapColor(MURUBLIGHT_STEM.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
    public static final Supplier<Block> MURUBLIGHT_WALL_HANGING_SIGN = EnderscapeBlocks.register(false, "murublight_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(MURUBLIGHT_WOOD_TYPE, properties), EnderscapeBlocks.wallVariant(MURUBLIGHT_HANGING_SIGN, p -> p.mapColor(MURUBLIGHT_STEM.get().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final Supplier<Block> POTTED_ALLURING_MAGNIA_SPROUT = EnderscapeBlocks.register(false, "potted_alluring_magnia_sprout", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, ALLURING_MAGNIA_SPROUT, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_BLINKLIGHT = EnderscapeBlocks.register(false, "potted_blinklight", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BLINKLIGHT_VINES_HEAD, properties), EnderscapeBlocks.flowerPotProperties().lightLevel(state -> 12));
    public static final Supplier<Block> POTTED_BULB_FLOWER = EnderscapeBlocks.register(false, "potted_bulb_flower", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BULB_FLOWER, properties), EnderscapeBlocks.flowerPotProperties().lightLevel(state -> 7));
    public static final Supplier<Block> POTTED_CELESTIAL_CHANTERELLE = EnderscapeBlocks.register(false, "potted_celestial_chanterelle", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, CELESTIAL_CHANTERELLE, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_CELESTIAL_GROWTH = EnderscapeBlocks.register(false, "potted_celestial_growth", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, CELESTIAL_GROWTH, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_CHORUS_SPROUTS = EnderscapeBlocks.register(false, "potted_chorus_sprouts", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, CHORUS_SPROUTS, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_CORRUPT_GROWTH = EnderscapeBlocks.register(false, "potted_corrupt_growth", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, CORRUPT_GROWTH, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_DRY_END_GROWTH = EnderscapeBlocks.register(false, "potted_dry_end_growth", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, DRY_END_GROWTH, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_MURUBLIGHT_CHANTERELLE = EnderscapeBlocks.register(false, "potted_murublight_chanterelle", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, MURUBLIGHT_CHANTERELLE, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_REPULSIVE_MAGNIA_SPROUT = EnderscapeBlocks.register(false, "potted_repulsive_magnia_sprout", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, REPULSIVE_MAGNIA_SPROUT, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_VEILED_SAPLING = EnderscapeBlocks.register(false, "potted_veiled_sapling", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, VEILED_SAPLING, properties), EnderscapeBlocks.flowerPotProperties());
    public static final Supplier<Block> POTTED_WISP_GROWTH = EnderscapeBlocks.register(false, "potted_wisp_growth", (BlockBehaviour.Properties properties) -> EnderscapeBlocks.createFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, WISP_GROWTH, properties), EnderscapeBlocks.flowerPotProperties());
    private static final List<FlowerPotBlock> FLOWER_POT_BLOCKS = new ArrayList<FlowerPotBlock>();
    public static final Supplier<BlockStateProvider> VEILED_OVERGROWTH_BONEMEAL_PROVIDER = Suppliers.memoize(() -> new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)WISP_SPROUTS.get().defaultBlockState(), 3).add((Object)WISP_GROWTH.get().defaultBlockState(), 1)));
    public static final Supplier<BlockStateProvider> CELESTIAL_OVERGROWTH_BONEMEAL_PROVIDER = Suppliers.memoize(() -> new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)CELESTIAL_CHANTERELLE.get().defaultBlockState(), 3).add((Object)BULB_FLOWER.get().defaultBlockState(), 1)));
    public static final Supplier<BlockStateProvider> CORRUPT_OVERGROWTH_BONEMEAL_PROVIDER = Suppliers.memoize(() -> new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)MURUBLIGHT_CHANTERELLE.get().defaultBlockState(), 3)));

    private static FlowerPotBlock createFlowerPotBlock(Supplier<FlowerPotBlock> flowerPot, Supplier<? extends Block> content, BlockBehaviour.Properties properties) {
        FlowerPotBlock block = new FlowerPotBlock(flowerPot, content, properties);
        FLOWER_POT_BLOCKS.add(block);
        return block;
    }

    @SubscribeEvent
    public static void onFmlCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FlowerPotBlock empty = (FlowerPotBlock)Blocks.FLOWER_POT;
            for (FlowerPotBlock block : FLOWER_POT_BLOCKS) {
                empty.addPlant(BuiltInRegistries.BLOCK.getKey((Object)block.getPotted()), () -> block);
            }
        });
    }

    private static Supplier<Block> registerStair(String string, Supplier<Block> block) {
        return EnderscapeBlocks.register(true, string, (BlockBehaviour.Properties properties) -> new StairBlock(((Block)block.get()).defaultBlockState(), properties), EnderscapeBlocks.fullCopyOf(block));
    }

    public static BlockBehaviour.Properties flowerPotProperties() {
        return BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties leavesProperties(SoundType soundType) {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(soundType).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(EnderscapeBlocks::never).isViewBlocking(EnderscapeBlocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(EnderscapeBlocks::never);
    }

    public static Supplier<BlockBehaviour.Properties> legacyCopyOf(Block block) {
        return EnderscapeBlocks.legacyCopyOf(() -> block);
    }

    public static Supplier<BlockBehaviour.Properties> legacyCopyOf(Block block, UnaryOperator<BlockBehaviour.Properties> operator) {
        return EnderscapeBlocks.legacyCopyOf(() -> block, operator);
    }

    public static Supplier<BlockBehaviour.Properties> legacyCopyOf(Supplier<Block> block) {
        return EnderscapeBlocks.legacyCopyOf(block, p -> p);
    }

    public static Supplier<BlockBehaviour.Properties> legacyCopyOf(Supplier<Block> block, UnaryOperator<BlockBehaviour.Properties> operator) {
        return () -> (BlockBehaviour.Properties)operator.apply(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)block.get())));
    }

    public static Supplier<BlockBehaviour.Properties> fullCopyOf(Block block) {
        return EnderscapeBlocks.fullCopyOf(() -> block);
    }

    public static Supplier<BlockBehaviour.Properties> fullCopyOf(Block block, UnaryOperator<BlockBehaviour.Properties> operator) {
        return EnderscapeBlocks.fullCopyOf(() -> block, operator);
    }

    public static Supplier<BlockBehaviour.Properties> fullCopyOf(Supplier<Block> block) {
        return EnderscapeBlocks.fullCopyOf(block, p -> p);
    }

    public static Supplier<BlockBehaviour.Properties> fullCopyOf(Supplier<Block> block, UnaryOperator<BlockBehaviour.Properties> operator) {
        return () -> (BlockBehaviour.Properties)operator.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
    }

    private static Supplier<BlockBehaviour.Properties> wallVariant(Supplier<Block> block, UnaryOperator<BlockBehaviour.Properties> operator) {
        return () -> (BlockBehaviour.Properties)operator.apply(BlockBehaviour.Properties.of().dropsLike((Block)block.get()));
    }

    private static Supplier<Block> register(boolean hasItem, String string, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        return EnderscapeBlocks.register(hasItem, string, function, () -> properties);
    }

    private static Supplier<Block> register(boolean hasItem, String string, Function<BlockBehaviour.Properties, Block> function, Supplier<BlockBehaviour.Properties> properties) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Enderscape.id(string));
        Supplier<Block> block = RegistryHelper.register(BuiltInRegistries.BLOCK, key, () -> (Block)function.apply((BlockBehaviour.Properties)properties.get()));
        if (hasItem) {
            EnderscapeItems.registerBlock(block, (ResourceKey<Block>)key);
        }
        return block;
    }

    private static WoodType registerWoodType(ResourceLocation location, BlockSetType setType, SoundType soundType, SoundType hangingSignSoundType, SoundEvent fenceGateClose, SoundEvent fenceGateOpen) {
        WoodType woodType = new WoodType(location.toString(), setType, soundType, hangingSignSoundType, fenceGateClose, fenceGateOpen);
        WoodType.register((WoodType)woodType);
        return woodType;
    }

    private static boolean always(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    private static Boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }
}

