/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.feature.CeilingOreConfig;
import net.bunten.enderscape.feature.GrowthConfig;
import net.bunten.enderscape.feature.LargeCelestialChanterelleConfig;
import net.bunten.enderscape.feature.LargeMurublightChanterelleConfig;
import net.bunten.enderscape.feature.MagniaTowerConfig;
import net.bunten.enderscape.feature.ScatteredOreConfig;
import net.bunten.enderscape.feature.VeiledLeafPileConfig;
import net.bunten.enderscape.feature.VeiledTreeConfig;
import net.bunten.enderscape.feature.VoidShaleConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeFeatures;
import net.bunten.enderscape.registry.RegistryHelper;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class EnderscapeConfiguredFeatures {
    public static final List<ResourceKey<ConfiguredFeature<?, ?>>> CONFIGURED_FEATURES = new ArrayList();
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLINKLIGHT_VINES = EnderscapeConfiguredFeatures.registerKey("blinklight_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BULB_FLOWER = EnderscapeConfiguredFeatures.registerKey("bulb_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CEILING_NEBULITE_ORE = EnderscapeConfiguredFeatures.registerKey("ceiling_nebulite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELESTIAL_GROVE_VEGETATION = EnderscapeConfiguredFeatures.registerKey("celestial_grove_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELESTIAL_GROWTH = EnderscapeConfiguredFeatures.registerKey("celestial_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHORUS_SPROUTS = EnderscapeConfiguredFeatures.registerKey("chorus_sprouts");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CORRUPT_BARRENS_VEGETATION = EnderscapeConfiguredFeatures.registerKey("corrupt_barrens_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOWNWARD_CORRUPT_GROWTH = EnderscapeConfiguredFeatures.registerKey("downward_corrupt_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOWNWARD_LARGE_MURUBLIGHT_CHANTERELLE = EnderscapeConfiguredFeatures.registerKey("downward_large_murublight_chanterelle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOWNWARD_TALL_CORRUPT_GROWTH = EnderscapeConfiguredFeatures.registerKey("downward_tall_corrupt_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRY_END_GROWTH = EnderscapeConfiguredFeatures.registerKey("dry_end_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ENDERSCAPE_ISLAND = EnderscapeConfiguredFeatures.registerKey("enderscape_island");
    public static final ResourceKey<ConfiguredFeature<?, ?>> KURODITE = EnderscapeConfiguredFeatures.registerKey("kurodite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_CELESTIAL_CHANTERELLE = EnderscapeConfiguredFeatures.registerKey("large_celestial_chanterelle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGNIA_ARCH = EnderscapeConfiguredFeatures.registerKey("magnia_arch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGNIA_TOWER = EnderscapeConfiguredFeatures.registerKey("magnia_tower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MIRESTONE_BLOB = EnderscapeConfiguredFeatures.registerKey("mirestone_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MIRESTONE_PILLARS = EnderscapeConfiguredFeatures.registerKey("mirestone_pillars");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MURUBLIGHT_SHELF = EnderscapeConfiguredFeatures.registerKey("murublight_shelf");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NEBULITE_ORE = EnderscapeConfiguredFeatures.registerKey("nebulite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOWNWARD_REPULSIVE_MAGNIA_SPROUT = EnderscapeConfiguredFeatures.registerKey("downward_repulsive_magnia_sprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCATTERED_SHADOLINE_ORE = EnderscapeConfiguredFeatures.registerKey("scattered_shadoline_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHADOLINE_ORE = EnderscapeConfiguredFeatures.registerKey("shadoline_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UPWARD_ALLURING_MAGNIA_SPROUT = EnderscapeConfiguredFeatures.registerKey("upward_alluring_magnia_sprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UPWARD_CORRUPT_GROWTH = EnderscapeConfiguredFeatures.registerKey("upward_corrupt_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UPWARD_LARGE_MURUBLIGHT_CHANTERELLE = EnderscapeConfiguredFeatures.registerKey("upward_large_murublight_chanterelle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UPWARD_TALL_CORRUPT_GROWTH = EnderscapeConfiguredFeatures.registerKey("upward_tall_corrupt_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VEILED_TREE = EnderscapeConfiguredFeatures.registerKey("veiled_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VEILED_TREE_FROM_SAPLING = EnderscapeConfiguredFeatures.registerKey("veiled_tree_from_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VEILED_WOODLANDS_VEGETATION = EnderscapeConfiguredFeatures.registerKey("veiled_woodlands_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VERADITE = EnderscapeConfiguredFeatures.registerKey("veradite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VOID_SHALE = EnderscapeConfiguredFeatures.registerKey("void_shale");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VOID_SHALE_BLOB = EnderscapeConfiguredFeatures.registerKey("void_shale_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WISP_FLOWER_PATCH = EnderscapeConfiguredFeatures.registerKey("wisp_flower_patch");
    private final List<OreConfiguration.TargetBlockState> kuroditeTargets = List.of(OreConfiguration.target((RuleTest)new TagMatchTest(EnderscapeBlockTags.ORE_REPLACEABLE), (BlockState)EnderscapeBlocks.KURODITE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> nebuliteOreTargets = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.END_STONE), (BlockState)EnderscapeBlocks.NEBULITE_ORE.get().defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(EnderscapeBlocks.MIRESTONE.get()), (BlockState)EnderscapeBlocks.MIRESTONE_NEBULITE_ORE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> shadolineOreTargets = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.END_STONE), (BlockState)EnderscapeBlocks.SHADOLINE_ORE.get().defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(EnderscapeBlocks.MIRESTONE.get()), (BlockState)EnderscapeBlocks.MIRESTONE_SHADOLINE_ORE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> veraditeTargets = List.of(OreConfiguration.target((RuleTest)new TagMatchTest(EnderscapeBlockTags.ORE_REPLACEABLE), (BlockState)EnderscapeBlocks.VERADITE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> voidShaleTargets = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(EnderscapeBlocks.MIRESTONE.get()), (BlockState)EnderscapeBlocks.VOID_SHALE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> voidShaleBlobsTargets = List.of(OreConfiguration.target((RuleTest)new TagMatchTest(EnderscapeBlockTags.ORE_REPLACEABLE), (BlockState)EnderscapeBlocks.VOID_SHALE.get().defaultBlockState()));
    private final List<OreConfiguration.TargetBlockState> mirestoneBlobTargets = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.END_STONE), (BlockState)EnderscapeBlocks.MIRESTONE.get().defaultBlockState()));

    public EnderscapeConfiguredFeatures() {
        RegistryHelper.checkAllReady();
    }

    public void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        this.registerVeiledWoodlands(context);
        this.registerMagniaCrags(context);
        this.registerCelestialGrove(context);
        this.registerCorruptBarrens(context);
        FeatureUtils.register(context, ENDERSCAPE_ISLAND, EnderscapeFeatures.ENDERSCAPE_ISLAND.get(), (FeatureConfiguration)NoneFeatureConfiguration.NONE);
        FeatureUtils.register(context, CHORUS_SPROUTS, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.CHORUS_SPROUTS.get())));
        FeatureUtils.register(context, DRY_END_GROWTH, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.DRY_END_GROWTH.get())));
        FeatureUtils.register(context, MURUBLIGHT_SHELF, EnderscapeFeatures.MURUBLIGHT_SHELF.get(), (FeatureConfiguration)NoneFeatureConfiguration.NONE);
        FeatureUtils.register(context, NEBULITE_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.nebuliteOreTargets, 4));
        FeatureUtils.register(context, CEILING_NEBULITE_ORE, EnderscapeFeatures.CEILING_ORE.get(), (FeatureConfiguration)new CeilingOreConfig(this.nebuliteOreTargets, (IntProvider)ConstantInt.of((int)8)));
        FeatureUtils.register(context, SHADOLINE_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.shadolineOreTargets, 10));
        FeatureUtils.register(context, SCATTERED_SHADOLINE_ORE, EnderscapeFeatures.SCATTERED_ORE.get(), (FeatureConfiguration)new ScatteredOreConfig(this.shadolineOreTargets, (IntProvider)UniformInt.of((int)70, (int)90), (IntProvider)UniformInt.of((int)-1, (int)1), (IntProvider)ConstantInt.of((int)1)));
        FeatureUtils.register(context, VERADITE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.veraditeTargets, 28));
        FeatureUtils.register(context, VOID_SHALE, EnderscapeFeatures.VOID_SHALE.get(), (FeatureConfiguration)new VoidShaleConfig(this.voidShaleTargets, (IntProvider)ConstantInt.of((int)5)));
        FeatureUtils.register(context, VOID_SHALE_BLOB, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.voidShaleBlobsTargets, 16, 1.0f));
        FeatureUtils.register(context, MIRESTONE_BLOB, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.mirestoneBlobTargets, 16, 0.5f));
    }

    private void registerVeiledWoodlands(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, VEILED_WOODLANDS_VEGETATION, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)EnderscapeBlocks.WISP_SPROUTS.get().defaultBlockState(), 4).add((Object)EnderscapeBlocks.WISP_GROWTH.get().defaultBlockState(), 1))));
        FeatureUtils.register(context, WISP_FLOWER_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.WISP_FLOWER.get())), List.of(), (int)16));
        FeatureUtils.register(context, VEILED_TREE, EnderscapeFeatures.VEILED_TREE.get(), (FeatureConfiguration)new VeiledTreeConfig((IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)ConstantInt.of((int)3), (IntProvider)UniformInt.of((int)4, (int)5), (FloatProvider)ConstantFloat.of((float)0.6f), Optional.of(new GrowthConfig(EnderscapeBlocks.VEILED_VINES.get().defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)1, (int)6), 0.15f)), Optional.of(new VeiledLeafPileConfig((FloatProvider)UniformFloat.of((float)6.0f, (float)10.0f), (FloatProvider)ConstantFloat.of((float)0.2f), (IntProvider)UniformInt.of((int)1, (int)2)))));
        FeatureUtils.register(context, VEILED_TREE_FROM_SAPLING, EnderscapeFeatures.VEILED_TREE.get(), (FeatureConfiguration)new VeiledTreeConfig((IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)ConstantInt.of((int)3), (IntProvider)UniformInt.of((int)4, (int)5), (FloatProvider)ConstantFloat.of((float)0.6f), Optional.of(new GrowthConfig(EnderscapeBlocks.VEILED_VINES.get().defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)1, (int)6), 0.15f)), Optional.empty()));
    }

    private void registerMagniaCrags(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, UPWARD_ALLURING_MAGNIA_SPROUT, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.get())));
        FeatureUtils.register(context, DOWNWARD_REPULSIVE_MAGNIA_SPROUT, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)Direction.DOWN))))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        FeatureUtils.register(context, MAGNIA_ARCH, EnderscapeFeatures.MAGNIA_ARCH.get(), (FeatureConfiguration)new NoneFeatureConfiguration());
        FeatureUtils.register(context, MAGNIA_TOWER, EnderscapeFeatures.MAGNIA_TOWER.get(), (FeatureConfiguration)new MagniaTowerConfig((FloatProvider)UniformFloat.of((float)6.0f, (float)8.0f), (IntProvider)UniformInt.of((int)12, (int)18), (IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)7), (FloatProvider)ConstantFloat.of((float)0.06f)));
    }

    private void registerCelestialGrove(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, BULB_FLOWER, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.BULB_FLOWER.get())));
        FeatureUtils.register(context, CELESTIAL_GROVE_VEGETATION, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)EnderscapeBlocks.CELESTIAL_CHANTERELLE.get().defaultBlockState(), 8).add((Object)EnderscapeBlocks.BULB_FLOWER.get().defaultBlockState(), 1))));
        FeatureUtils.register(context, CELESTIAL_GROWTH, EnderscapeFeatures.GROWTH.get(), (FeatureConfiguration)new GrowthConfig(EnderscapeBlocks.CELESTIAL_GROWTH.get().defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)1, (int)3), 0.125f));
        FeatureUtils.register(context, LARGE_CELESTIAL_CHANTERELLE, EnderscapeFeatures.LARGE_CELESTIAL_CHANTERELLE.get(), (FeatureConfiguration)new LargeCelestialChanterelleConfig((IntProvider)UniformInt.of((int)10, (int)35), 4.0f, 0.75f, 1.0f, 64, 16));
    }

    private void registerCorruptBarrens(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, MIRESTONE_PILLARS, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)BlockColumnConfiguration.simple((IntProvider)BiasedToBottomInt.of((int)1, (int)4), (BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.MIRESTONE.get())));
        FeatureUtils.register(context, KURODITE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(this.kuroditeTargets, 28));
        FeatureUtils.register(context, BLINKLIGHT_VINES, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)UniformInt.of((int)4, (int)15), (BlockStateProvider)BlockStateProvider.simple((Block)EnderscapeBlocks.BLINKLIGHT_VINES_BODY.get())), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)EnderscapeBlocks.BLINKLIGHT_VINES_HEAD.get().defaultBlockState().setValue((Property)StateProperties.AGE_25, (Comparable)Integer.valueOf(25)))))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        FeatureUtils.register(context, CORRUPT_BARRENS_VEGETATION, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)EnderscapeBlocks.MURUBLIGHT_CHANTERELLE.get().defaultBlockState(), 1))));
        FeatureUtils.register(context, UPWARD_CORRUPT_GROWTH, EnderscapeFeatures.GROWTH.get(), (FeatureConfiguration)new GrowthConfig((BlockState)EnderscapeBlocks.CORRUPT_GROWTH.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)Direction.UP), (IntProvider)ConstantInt.of((int)1), (IntProvider)UniformInt.of((int)0, (int)1), 0.3f));
        FeatureUtils.register(context, UPWARD_TALL_CORRUPT_GROWTH, EnderscapeFeatures.GROWTH.get(), (FeatureConfiguration)new GrowthConfig((BlockState)EnderscapeBlocks.CORRUPT_GROWTH.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)Direction.UP), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)ConstantInt.of((int)0), 0.0f));
        FeatureUtils.register(context, DOWNWARD_CORRUPT_GROWTH, EnderscapeFeatures.GROWTH.get(), (FeatureConfiguration)new GrowthConfig((BlockState)EnderscapeBlocks.CORRUPT_GROWTH.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)Direction.DOWN), (IntProvider)ConstantInt.of((int)1), (IntProvider)UniformInt.of((int)1, (int)2), 0.5f));
        FeatureUtils.register(context, DOWNWARD_TALL_CORRUPT_GROWTH, EnderscapeFeatures.GROWTH.get(), (FeatureConfiguration)new GrowthConfig((BlockState)EnderscapeBlocks.CORRUPT_GROWTH.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)Direction.DOWN), (IntProvider)UniformInt.of((int)4, (int)8), (IntProvider)ConstantInt.of((int)0), 0.0f));
        FeatureUtils.register(context, DOWNWARD_LARGE_MURUBLIGHT_CHANTERELLE, EnderscapeFeatures.LARGE_MURUBLIGHT_CHANTERELLE.get(), (FeatureConfiguration)new LargeMurublightChanterelleConfig(Direction.DOWN, (IntProvider)UniformInt.of((int)15, (int)30), (IntProvider)UniformInt.of((int)4, (int)6), 32));
        FeatureUtils.register(context, UPWARD_LARGE_MURUBLIGHT_CHANTERELLE, EnderscapeFeatures.LARGE_MURUBLIGHT_CHANTERELLE.get(), (FeatureConfiguration)new LargeMurublightChanterelleConfig(Direction.UP, (IntProvider)UniformInt.of((int)15, (int)30), (IntProvider)UniformInt.of((int)4, (int)6), 32));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Enderscape.id(name));
        CONFIGURED_FEATURES.add(key);
        return key;
    }
}

