/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapEncoder;
import java.util.Optional;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapePaintingVariants;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeCreativeModeTab {
    public static final Holder<CreativeModeTab> ENDERSCAPE = RegistryHelper.registerForHolder(BuiltInRegistries.CREATIVE_MODE_TAB, Enderscape.id("enderscape"), () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.enderscape")).icon(() -> ((Item)EnderscapeItems.NEBULITE.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)Items.ENDERMAN_SPAWN_EGG);
        output.accept((ItemLike)Items.ENDERMITE_SPAWN_EGG);
        output.accept((ItemLike)EnderscapeItems.RUBBLEMITE_SPAWN_EGG.get());
        output.accept((ItemLike)Items.SHULKER_SPAWN_EGG);
        output.accept((ItemLike)EnderscapeItems.RUSTLE_SPAWN_EGG.get());
        output.accept((ItemLike)EnderscapeItems.DRIFTER_SPAWN_EGG.get());
        output.accept((ItemLike)EnderscapeItems.DRIFTLET_SPAWN_EGG.get());
        output.accept((ItemLike)Items.DRAGON_BREATH);
        output.accept((ItemLike)EnderscapeItems.RUBBLE_CHITIN.get());
        output.accept((ItemLike)Items.SHULKER_SHELL);
        output.accept((ItemLike)EnderscapeItems.CRESCENT_BANNER_PATTERN.get());
        output.accept((ItemLike)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE);
        output.accept((ItemLike)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE);
        output.accept((ItemLike)EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        output.accept(EnderscapeCreativeModeTab.getEnchantedBook(parameters, EnderscapeEnchantments.LIGHTSPEED, 3));
        output.accept(EnderscapeCreativeModeTab.getEnchantedBook(parameters, EnderscapeEnchantments.TRANSDIMENSIONAL, 1));
        output.accept(EnderscapeCreativeModeTab.getEnchantedBook(parameters, EnderscapeEnchantments.REBOUND, 1));
        output.accept((ItemLike)Items.END_PORTAL_FRAME);
        output.accept((ItemLike)Items.ENDER_EYE);
        output.accept((ItemLike)Items.END_CRYSTAL);
        output.accept((ItemLike)Items.DRAGON_EGG);
        output.accept((ItemLike)Items.DRAGON_HEAD);
        output.accept((ItemLike)Items.ENDER_CHEST);
        output.accept((ItemLike)Items.SHULKER_BOX);
        output.accept(EnderscapeItems.getEndCityBannerInstance((HolderGetter<BannerPattern>)parameters.holders().lookupOrThrow(Registries.BANNER_PATTERN)));
        output.accept(EnderscapeCreativeModeTab.getPainting(parameters, EnderscapePaintingVariants.GRAPE_STATIC));
        output.accept((ItemLike)EnderscapeBlocks.END_TRIAL_SPAWNER.get());
        output.accept(EnderscapeItems.getEndVaultInstance());
        output.accept((ItemLike)EnderscapeItems.END_CITY_KEY.get());
        output.accept((ItemLike)Items.ENDER_PEARL);
        output.accept((ItemLike)EnderscapeItems.END_STONE_RUBBLE_SHIELD.get());
        output.accept((ItemLike)EnderscapeItems.VERADITE_RUBBLE_SHIELD.get());
        output.accept((ItemLike)EnderscapeItems.MIRESTONE_RUBBLE_SHIELD.get());
        output.accept((ItemLike)EnderscapeItems.KURODITE_RUBBLE_SHIELD.get());
        output.accept((ItemLike)EnderscapeItems.RUSTLE_BUCKET.get());
        output.accept((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get());
        output.accept((ItemLike)EnderscapeBlocks.DRIFT_JELLY_BLOCK.get());
        output.accept((ItemLike)EnderscapeItems.DRIFT_LEGGINGS.get());
        output.accept((ItemLike)EnderscapeItems.MAGNIA_ATTRACTOR.get());
        output.accept((ItemLike)EnderscapeItems.MIRROR.get());
        output.accept((ItemLike)Items.ELYTRA);
        output.accept((ItemLike)EnderscapeItems.MUSIC_DISC_GLARE.get());
        output.accept((ItemLike)EnderscapeItems.MUSIC_DISC_DECAY.get());
        output.accept((ItemLike)EnderscapeItems.MUSIC_DISC_BLISS.get());
        output.accept((ItemLike)Items.END_STONE);
        output.accept((ItemLike)EnderscapeBlocks.END_STONE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.END_STONE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.END_STONE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_BUTTON.get());
        output.accept((ItemLike)Items.END_STONE_BRICKS);
        output.accept((ItemLike)Items.END_STONE_BRICK_STAIRS);
        output.accept((ItemLike)Items.END_STONE_BRICK_SLAB);
        output.accept((ItemLike)Items.END_STONE_BRICK_WALL);
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_END_STONE.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_BUTTON.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_BRICK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_BRICK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.VERADITE_BRICK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_VERADITE.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_BUTTON.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_MIRESTONE.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_BUTTON.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_BRICK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_BRICK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.KURODITE_BRICK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_KURODITE.get());
        output.accept((ItemLike)EnderscapeBlocks.ALLURING_MAGNIA.get());
        output.accept((ItemLike)EnderscapeBlocks.ETCHED_ALLURING_MAGNIA.get());
        output.accept((ItemLike)EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.get());
        output.accept((ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA.get());
        output.accept((ItemLike)EnderscapeBlocks.ETCHED_REPULSIVE_MAGNIA.get());
        output.accept((ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT.get());
        output.accept((ItemLike)EnderscapeBlocks.VOID_SHALE.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_ORE.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_SHADOLINE_ORE.get());
        output.accept((ItemLike)EnderscapeItems.RAW_SHADOLINE.get());
        output.accept((ItemLike)EnderscapeBlocks.RAW_SHADOLINE_BLOCK.get());
        output.accept((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CUT_SHADOLINE.get());
        output.accept((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_SHADOLINE.get());
        output.accept((ItemLike)EnderscapeBlocks.SHADOLINE_PILLAR.get());
        output.accept((ItemLike)EnderscapeBlocks.NEBULITE_ORE.get());
        output.accept((ItemLike)EnderscapeBlocks.MIRESTONE_NEBULITE_ORE.get());
        output.accept((ItemLike)EnderscapeItems.NEBULITE_SHARDS.get());
        output.accept((ItemLike)EnderscapeItems.NEBULITE.get());
        output.accept((ItemLike)EnderscapeBlocks.NEBULITE_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.DRY_END_GROWTH.get());
        output.accept((ItemLike)EnderscapeBlocks.CHORUS_SPROUTS.get());
        output.accept((ItemLike)Items.CHORUS_PLANT);
        output.accept((ItemLike)Items.CHORUS_FLOWER);
        output.accept((ItemLike)Items.CHORUS_FRUIT);
        output.accept((ItemLike)Items.POPPED_CHORUS_FRUIT);
        output.accept((ItemLike)EnderscapeItems.CHORUS_CAKE_ROLL_ITEM.get());
        output.accept((ItemLike)Items.PURPUR_BLOCK);
        output.accept((ItemLike)Items.PURPUR_STAIRS);
        output.accept((ItemLike)Items.PURPUR_SLAB);
        output.accept((ItemLike)EnderscapeBlocks.PURPUR_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_PURPUR.get());
        output.accept((ItemLike)Items.PURPUR_PILLAR);
        output.accept((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.DUSK_PURPUR_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.DUSK_PURPUR_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.DUSK_PURPUR_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CHISELED_DUSK_PURPUR.get());
        output.accept((ItemLike)EnderscapeBlocks.DUSK_PURPUR_PILLAR.get());
        output.accept((ItemLike)EnderscapeBlocks.PURPUR_TILES.get());
        output.accept((ItemLike)EnderscapeBlocks.PURPUR_TILE_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.PURPUR_TILE_SLAB.get());
        output.accept((ItemLike)Items.END_ROD);
        output.accept((ItemLike)EnderscapeBlocks.END_LAMP.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_END_STONE.get());
        output.accept((ItemLike)EnderscapeBlocks.WISP_SPROUTS.get());
        output.accept((ItemLike)EnderscapeBlocks.WISP_GROWTH.get());
        output.accept((ItemLike)EnderscapeBlocks.WISP_FLOWER.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_SAPLING.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_LEAVES.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_LEAF_PILE.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_VINES.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_LOG.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_VEILED_LOG.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_WOOD.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_VEILED_WOOD.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_PLANKS.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_FENCE.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_FENCE_GATE.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_DOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_TRAPDOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.VEILED_BUTTON.get());
        output.accept((ItemLike)EnderscapeItems.VEILED_SIGN_ITEM.get());
        output.accept((ItemLike)EnderscapeItems.VEILED_HANGING_SIGN_ITEM.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_OVERGROWTH.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_PATH_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_GROWTH.get());
        output.accept((ItemLike)EnderscapeBlocks.BULB_FLOWER.get());
        output.accept((ItemLike)EnderscapeBlocks.BULB_LANTERN.get());
        output.accept((ItemLike)EnderscapeItems.FLANGER_BERRY.get());
        output.accept((ItemLike)EnderscapeBlocks.FLANGER_BERRY_FLOWER.get());
        output.accept((ItemLike)EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_CHANTERELLE.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_CAP.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_BRICKS.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_STEM.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_CELESTIAL_STEM.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_HYPHAE.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_CELESTIAL_HYPHAE.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_PLANKS.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_FENCE.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_FENCE_GATE.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_DOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_TRAPDOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.CELESTIAL_BUTTON.get());
        output.accept((ItemLike)EnderscapeItems.CELESTIAL_SIGN_ITEM.get());
        output.accept((ItemLike)EnderscapeItems.CELESTIAL_HANGING_SIGN_ITEM.get());
        output.accept((ItemLike)EnderscapeBlocks.CORRUPT_OVERGROWTH.get());
        output.accept((ItemLike)EnderscapeBlocks.CORRUPT_PATH_BLOCK.get());
        output.accept((ItemLike)EnderscapeBlocks.CORRUPT_GROWTH.get());
        output.accept((ItemLike)EnderscapeItems.BLINKLIGHT.get());
        output.accept((ItemLike)EnderscapeBlocks.BLINKLAMP.get());
        output.accept((ItemLike)EnderscapeItems.MURUBLIGHT_SHELF_ITEM.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_CHANTERELLE.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_CAP.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICKS.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_WALL.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_STEM.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_HYPHAE.get());
        output.accept((ItemLike)EnderscapeBlocks.STRIPPED_MURUBLIGHT_HYPHAE.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_PLANKS.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_STAIRS.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_SLAB.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_FENCE.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_FENCE_GATE.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_DOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_TRAPDOOR.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_PRESSURE_PLATE.get());
        output.accept((ItemLike)EnderscapeBlocks.MURUBLIGHT_BUTTON.get());
        output.accept((ItemLike)EnderscapeItems.MURUBLIGHT_SIGN_ITEM.get());
        output.accept((ItemLike)EnderscapeItems.MURUBLIGHT_HANGING_SIGN_ITEM.get());
    }).build());

    @SubscribeEvent
    public static void modifyCreativeModeTabListener(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            EnderscapeCreativeModeTab.addAfter(event, Items.END_STONE, EnderscapeBlocks.END_STONE_STAIRS, EnderscapeBlocks.END_STONE_SLAB, EnderscapeBlocks.END_STONE_WALL, EnderscapeBlocks.CHISELED_END_STONE, EnderscapeBlocks.POLISHED_END_STONE, EnderscapeBlocks.POLISHED_END_STONE_STAIRS, EnderscapeBlocks.POLISHED_END_STONE_SLAB, EnderscapeBlocks.POLISHED_END_STONE_WALL, EnderscapeBlocks.POLISHED_END_STONE_PRESSURE_PLATE, EnderscapeBlocks.POLISHED_END_STONE_BUTTON);
            EnderscapeCreativeModeTab.addAfter(event, Items.END_STONE_BRICK_WALL, EnderscapeBlocks.VERADITE, EnderscapeBlocks.VERADITE_STAIRS, EnderscapeBlocks.VERADITE_SLAB, EnderscapeBlocks.VERADITE_WALL, EnderscapeBlocks.CHISELED_VERADITE, EnderscapeBlocks.POLISHED_VERADITE, EnderscapeBlocks.POLISHED_VERADITE_STAIRS, EnderscapeBlocks.POLISHED_VERADITE_SLAB, EnderscapeBlocks.POLISHED_VERADITE_WALL, EnderscapeBlocks.POLISHED_VERADITE_PRESSURE_PLATE, EnderscapeBlocks.POLISHED_VERADITE_BUTTON, EnderscapeBlocks.VERADITE_BRICKS, EnderscapeBlocks.VERADITE_BRICK_STAIRS, EnderscapeBlocks.VERADITE_BRICK_SLAB, EnderscapeBlocks.VERADITE_BRICK_WALL, EnderscapeBlocks.MIRESTONE, EnderscapeBlocks.MIRESTONE_STAIRS, EnderscapeBlocks.MIRESTONE_SLAB, EnderscapeBlocks.MIRESTONE_WALL, EnderscapeBlocks.CHISELED_MIRESTONE, EnderscapeBlocks.POLISHED_MIRESTONE, EnderscapeBlocks.POLISHED_MIRESTONE_STAIRS, EnderscapeBlocks.POLISHED_MIRESTONE_SLAB, EnderscapeBlocks.POLISHED_MIRESTONE_WALL, EnderscapeBlocks.POLISHED_MIRESTONE_PRESSURE_PLATE, EnderscapeBlocks.POLISHED_MIRESTONE_BUTTON, EnderscapeBlocks.MIRESTONE_BRICKS, EnderscapeBlocks.MIRESTONE_BRICK_STAIRS, EnderscapeBlocks.MIRESTONE_BRICK_SLAB, EnderscapeBlocks.MIRESTONE_BRICK_WALL, EnderscapeBlocks.KURODITE, EnderscapeBlocks.KURODITE_STAIRS, EnderscapeBlocks.KURODITE_SLAB, EnderscapeBlocks.KURODITE_WALL, EnderscapeBlocks.CHISELED_KURODITE, EnderscapeBlocks.POLISHED_KURODITE, EnderscapeBlocks.POLISHED_KURODITE_STAIRS, EnderscapeBlocks.POLISHED_KURODITE_SLAB, EnderscapeBlocks.POLISHED_KURODITE_WALL, EnderscapeBlocks.POLISHED_KURODITE_PRESSURE_PLATE, EnderscapeBlocks.POLISHED_KURODITE_BUTTON, EnderscapeBlocks.KURODITE_BRICKS, EnderscapeBlocks.KURODITE_BRICK_STAIRS, EnderscapeBlocks.KURODITE_BRICK_SLAB, EnderscapeBlocks.KURODITE_BRICK_WALL, EnderscapeBlocks.ALLURING_MAGNIA, EnderscapeBlocks.ETCHED_ALLURING_MAGNIA, EnderscapeBlocks.REPULSIVE_MAGNIA, EnderscapeBlocks.ETCHED_REPULSIVE_MAGNIA);
            EnderscapeCreativeModeTab.addBefore(event, Items.PURPUR_PILLAR, EnderscapeBlocks.CHISELED_PURPUR);
            EnderscapeCreativeModeTab.addAfter(event, Items.PURPUR_SLAB, EnderscapeBlocks.PURPUR_WALL, EnderscapeBlocks.DUSK_PURPUR_BLOCK, EnderscapeBlocks.CHISELED_DUSK_PURPUR, EnderscapeBlocks.DUSK_PURPUR_PILLAR, EnderscapeBlocks.DUSK_PURPUR_STAIRS, EnderscapeBlocks.DUSK_PURPUR_SLAB, EnderscapeBlocks.DUSK_PURPUR_WALL, EnderscapeBlocks.PURPUR_TILES, EnderscapeBlocks.PURPUR_TILE_STAIRS, EnderscapeBlocks.PURPUR_TILE_SLAB, EnderscapeBlocks.CELESTIAL_BRICKS, EnderscapeBlocks.CELESTIAL_BRICK_STAIRS, EnderscapeBlocks.CELESTIAL_BRICK_SLAB, EnderscapeBlocks.CELESTIAL_BRICK_WALL, EnderscapeBlocks.MURUBLIGHT_BRICKS, EnderscapeBlocks.MURUBLIGHT_BRICK_STAIRS, EnderscapeBlocks.MURUBLIGHT_BRICK_SLAB, EnderscapeBlocks.MURUBLIGHT_BRICK_WALL);
            EnderscapeCreativeModeTab.addAfter(event, Items.WARPED_BUTTON, EnderscapeBlocks.VEILED_LOG, EnderscapeBlocks.STRIPPED_VEILED_LOG, EnderscapeBlocks.VEILED_WOOD, EnderscapeBlocks.STRIPPED_VEILED_WOOD, EnderscapeBlocks.VEILED_PLANKS, EnderscapeBlocks.VEILED_STAIRS, EnderscapeBlocks.VEILED_SLAB, EnderscapeBlocks.VEILED_FENCE, EnderscapeBlocks.VEILED_FENCE_GATE, EnderscapeBlocks.VEILED_DOOR, EnderscapeBlocks.VEILED_TRAPDOOR, EnderscapeBlocks.VEILED_PRESSURE_PLATE, EnderscapeBlocks.VEILED_BUTTON, EnderscapeBlocks.CELESTIAL_STEM, EnderscapeBlocks.STRIPPED_CELESTIAL_STEM, EnderscapeBlocks.CELESTIAL_HYPHAE, EnderscapeBlocks.STRIPPED_CELESTIAL_HYPHAE, EnderscapeBlocks.CELESTIAL_PLANKS, EnderscapeBlocks.CELESTIAL_STAIRS, EnderscapeBlocks.CELESTIAL_SLAB, EnderscapeBlocks.CELESTIAL_FENCE, EnderscapeBlocks.CELESTIAL_FENCE_GATE, EnderscapeBlocks.CELESTIAL_DOOR, EnderscapeBlocks.CELESTIAL_TRAPDOOR, EnderscapeBlocks.CELESTIAL_PRESSURE_PLATE, EnderscapeBlocks.CELESTIAL_BUTTON, EnderscapeBlocks.MURUBLIGHT_STEM, EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM, EnderscapeBlocks.MURUBLIGHT_HYPHAE, EnderscapeBlocks.STRIPPED_MURUBLIGHT_HYPHAE, EnderscapeBlocks.MURUBLIGHT_PLANKS, EnderscapeBlocks.MURUBLIGHT_STAIRS, EnderscapeBlocks.MURUBLIGHT_SLAB, EnderscapeBlocks.MURUBLIGHT_FENCE, EnderscapeBlocks.MURUBLIGHT_FENCE_GATE, EnderscapeBlocks.MURUBLIGHT_DOOR, EnderscapeBlocks.MURUBLIGHT_TRAPDOOR, EnderscapeBlocks.MURUBLIGHT_PRESSURE_PLATE, EnderscapeBlocks.MURUBLIGHT_BUTTON);
            EnderscapeCreativeModeTab.addAfter(event, Items.NETHERITE_BLOCK, EnderscapeBlocks.NEBULITE_BLOCK);
            EnderscapeCreativeModeTab.addAfter(event, Items.WAXED_OXIDIZED_COPPER_BULB, EnderscapeBlocks.SHADOLINE_BLOCK, EnderscapeBlocks.SHADOLINE_BLOCK_STAIRS, EnderscapeBlocks.SHADOLINE_BLOCK_SLAB, EnderscapeBlocks.SHADOLINE_BLOCK_WALL, EnderscapeBlocks.CUT_SHADOLINE, EnderscapeBlocks.CUT_SHADOLINE_STAIRS, EnderscapeBlocks.CUT_SHADOLINE_SLAB, EnderscapeBlocks.CUT_SHADOLINE_WALL, EnderscapeBlocks.CHISELED_SHADOLINE, EnderscapeBlocks.SHADOLINE_PILLAR);
        } else if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            EnderscapeCreativeModeTab.addAfter(event, Items.END_STONE, EnderscapeBlocks.VEILED_END_STONE, EnderscapeBlocks.CELESTIAL_OVERGROWTH, EnderscapeBlocks.CELESTIAL_PATH_BLOCK, EnderscapeBlocks.MIRESTONE, EnderscapeBlocks.CORRUPT_OVERGROWTH, EnderscapeBlocks.CORRUPT_PATH_BLOCK, EnderscapeBlocks.VERADITE, EnderscapeBlocks.KURODITE, EnderscapeBlocks.ALLURING_MAGNIA, EnderscapeBlocks.ALLURING_MAGNIA_SPROUT, EnderscapeBlocks.REPULSIVE_MAGNIA, EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT, EnderscapeBlocks.VOID_SHALE);
            EnderscapeCreativeModeTab.addBefore(event, Items.RAW_IRON_BLOCK, EnderscapeBlocks.NEBULITE_ORE, EnderscapeBlocks.MIRESTONE_NEBULITE_ORE, EnderscapeBlocks.SHADOLINE_ORE, EnderscapeBlocks.MIRESTONE_SHADOLINE_ORE);
            EnderscapeCreativeModeTab.addBefore(event, Items.GLOWSTONE, EnderscapeBlocks.RAW_SHADOLINE_BLOCK);
            EnderscapeCreativeModeTab.addBefore(event, Items.MUSHROOM_STEM, EnderscapeBlocks.VEILED_LOG);
            EnderscapeCreativeModeTab.addBefore(event, Items.OAK_LEAVES, EnderscapeBlocks.CELESTIAL_STEM, EnderscapeBlocks.MURUBLIGHT_STEM);
            EnderscapeCreativeModeTab.addBefore(event, Items.BROWN_MUSHROOM_BLOCK, EnderscapeBlocks.VEILED_LEAVES, EnderscapeBlocks.VEILED_LEAF_PILE, EnderscapeBlocks.VEILED_VINES);
            EnderscapeCreativeModeTab.addBefore(event, Items.OAK_SAPLING, EnderscapeBlocks.CELESTIAL_CAP, EnderscapeBlocks.MURUBLIGHT_CAP);
            EnderscapeCreativeModeTab.addBefore(event, Items.SHORT_GRASS, EnderscapeBlocks.CELESTIAL_CHANTERELLE, EnderscapeBlocks.MURUBLIGHT_CHANTERELLE, EnderscapeItems.MURUBLIGHT_SHELF_ITEM);
            EnderscapeCreativeModeTab.addBefore(event, Items.BROWN_MUSHROOM, EnderscapeBlocks.VEILED_SAPLING);
            EnderscapeCreativeModeTab.addBefore(event, Items.VINE, EnderscapeBlocks.DRY_END_GROWTH, EnderscapeBlocks.CHORUS_SPROUTS, EnderscapeBlocks.WISP_SPROUTS, EnderscapeBlocks.WISP_GROWTH, EnderscapeBlocks.WISP_FLOWER, EnderscapeBlocks.CELESTIAL_GROWTH, EnderscapeBlocks.BULB_FLOWER, EnderscapeBlocks.CORRUPT_GROWTH, EnderscapeItems.BLINKLIGHT);
            EnderscapeCreativeModeTab.addAfter(event, Items.HONEY_BLOCK, EnderscapeBlocks.DRIFT_JELLY_BLOCK);
            EnderscapeCreativeModeTab.addAfter(event, Items.JACK_O_LANTERN, EnderscapeBlocks.FLANGER_BERRY_FLOWER, EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK, EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK);
        } else if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            EnderscapeCreativeModeTab.addBefore(event, Items.CHAIN, EnderscapeBlocks.BULB_LANTERN);
            EnderscapeCreativeModeTab.addBefore(event, Items.END_ROD, EnderscapeBlocks.END_LAMP);
            EnderscapeCreativeModeTab.addBefore(event, Items.CHEST, EnderscapeItems.VEILED_SIGN_ITEM, EnderscapeItems.VEILED_HANGING_SIGN_ITEM, EnderscapeItems.CELESTIAL_SIGN_ITEM, EnderscapeItems.CELESTIAL_HANGING_SIGN_ITEM, EnderscapeItems.MURUBLIGHT_SIGN_ITEM, EnderscapeItems.MURUBLIGHT_HANGING_SIGN_ITEM);
            event.insertBefore(Items.INFESTED_STONE.getDefaultInstance(), EnderscapeItems.getEndVaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertBefore(Items.SKELETON_SKULL.getDefaultInstance(), EnderscapeItems.getEndCityBannerInstance((HolderGetter<BannerPattern>)event.getParameters().holders().lookupOrThrow(Registries.BANNER_PATTERN)), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            EnderscapeCreativeModeTab.addAfter(event, Items.LIGHTNING_ROD, EnderscapeItems.BLINKLIGHT, EnderscapeItems.FLANGER_BERRY);
            EnderscapeCreativeModeTab.addAfter(event, Items.REDSTONE_LAMP, EnderscapeBlocks.BLINKLAMP);
            EnderscapeCreativeModeTab.addAfter(event, Items.BIG_DRIPLEAF, EnderscapeBlocks.ALLURING_MAGNIA_SPROUT, EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT);
        } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            EnderscapeCreativeModeTab.addAfter(event, Items.LEAD, EnderscapeItems.MAGNIA_ATTRACTOR);
            EnderscapeCreativeModeTab.addAfter(event, Items.ELYTRA, EnderscapeItems.MIRROR);
            EnderscapeCreativeModeTab.addBefore(event, Items.LAVA_BUCKET, EnderscapeItems.RUSTLE_BUCKET);
            EnderscapeCreativeModeTab.addAfter(event, Items.MUSIC_DISC_PIGSTEP, EnderscapeItems.MUSIC_DISC_GLARE, EnderscapeItems.MUSIC_DISC_DECAY, EnderscapeItems.MUSIC_DISC_BLISS);
        } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            EnderscapeCreativeModeTab.addBefore(event, Items.LEATHER_HELMET, EnderscapeItems.END_STONE_RUBBLE_SHIELD, EnderscapeItems.VERADITE_RUBBLE_SHIELD, EnderscapeItems.MIRESTONE_RUBBLE_SHIELD, EnderscapeItems.KURODITE_RUBBLE_SHIELD);
            EnderscapeCreativeModeTab.addAfter(event, Items.TURTLE_HELMET, EnderscapeItems.DRIFT_LEGGINGS);
        } else if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            EnderscapeCreativeModeTab.addBefore(event, Items.CARROT, EnderscapeItems.FLANGER_BERRY, EnderscapeItems.MURUBLIGHT_SHELF_ITEM);
            EnderscapeCreativeModeTab.addBefore(event, Items.PUMPKIN_PIE, EnderscapeItems.CHORUS_CAKE_ROLL_ITEM);
            EnderscapeCreativeModeTab.addAfter(event, Items.HONEY_BOTTLE, EnderscapeItems.DRIFT_JELLY_BOTTLE);
        } else if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            EnderscapeCreativeModeTab.addBefore(event, Items.SHULKER_SHELL, EnderscapeItems.RUBBLE_CHITIN);
            EnderscapeCreativeModeTab.addBefore(event, Items.ECHO_SHARD, EnderscapeItems.DRIFT_JELLY_BOTTLE);
            EnderscapeCreativeModeTab.addBefore(event, Items.EMERALD, EnderscapeItems.RAW_SHADOLINE);
            EnderscapeCreativeModeTab.addBefore(event, Items.STICK, EnderscapeItems.NEBULITE, EnderscapeItems.SHADOLINE_INGOT);
            EnderscapeCreativeModeTab.addBefore(event, Items.QUARTZ, EnderscapeItems.NEBULITE_SHARDS);
            EnderscapeCreativeModeTab.addAfter(event, Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE);
            EnderscapeCreativeModeTab.addAfter(event, Items.OMINOUS_TRIAL_KEY, EnderscapeItems.END_CITY_KEY);
            EnderscapeCreativeModeTab.addBefore(event, Items.ANGLER_POTTERY_SHERD, EnderscapeItems.CRESCENT_BANNER_PATTERN);
        } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            EnderscapeCreativeModeTab.addBefore(event, Items.ALLAY_SPAWN_EGG, EnderscapeBlocks.END_TRIAL_SPAWNER);
            EnderscapeCreativeModeTab.addAfter(event, Items.DONKEY_SPAWN_EGG, EnderscapeItems.DRIFTER_SPAWN_EGG, EnderscapeItems.DRIFTLET_SPAWN_EGG);
            EnderscapeCreativeModeTab.addAfter(event, Items.RAVAGER_SPAWN_EGG, EnderscapeItems.RUBBLEMITE_SPAWN_EGG, EnderscapeItems.RUSTLE_SPAWN_EGG);
        } else if (event.getTabKey() == CreativeModeTabs.OP_BLOCKS) {
            event.accept(EnderscapeItems.HEALING.get().asItem().getDefaultInstance());
        }
    }

    @SafeVarargs
    private static void addBefore(BuildCreativeModeTabContentsEvent event, Item target, Supplier<? extends ItemLike> ... toAdd) {
        for (int i = toAdd.length - 1; i >= 0; --i) {
            event.insertBefore(target.getDefaultInstance(), toAdd[i].get().asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SafeVarargs
    private static void addAfter(BuildCreativeModeTabContentsEvent event, Item target, Supplier<? extends ItemLike> ... toAdd) {
        for (int i = toAdd.length - 1; i >= 0; --i) {
            event.insertAfter(target.getDefaultInstance(), toAdd[i].get().asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static ItemStack getEnchantedBook(CreativeModeTab.ItemDisplayParameters parameters, ResourceKey<Enchantment> enchantment, int level) {
        HolderLookup.RegistryLookup lookup1;
        Optional enchantmentReference;
        Optional lookup = parameters.holders().lookup(Registries.ENCHANTMENT);
        if (lookup.isPresent() && (enchantmentReference = (lookup1 = (HolderLookup.RegistryLookup)lookup.get()).get(enchantment)).isPresent()) {
            Holder.Reference reference = (Holder.Reference)enchantmentReference.get();
            return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)reference, ((Enchantment)reference.value()).getMaxLevel()));
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getPainting(CreativeModeTab.ItemDisplayParameters parameters, ResourceKey<PaintingVariant> painting) {
        ItemStack stack = Items.PAINTING.getDefaultInstance();
        Holder.Reference reference = parameters.holders().lookupOrThrow(Registries.PAINTING_VARIANT).getOrThrow(painting);
        CustomData data = ((CustomData)CustomData.EMPTY.update((DynamicOps)parameters.holders().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapEncoder)Painting.VARIANT_MAP_CODEC, (Object)reference).getOrThrow()).update(compoundTag -> compoundTag.putString("id", "minecraft:painting"));
        stack.set(DataComponents.ENTITY_DATA, (Object)data);
        return stack;
    }
}

