/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;

public class EnderscapeDamageTypes {
    public static final List<ResourceKey<DamageType>> DAMAGE_TYPES = new ArrayList<ResourceKey<DamageType>>();
    public static final ResourceKey<DamageType> STOMP = EnderscapeDamageTypes.register("stomp");

    public void bootstrap(BootstrapContext<DamageType> context) {
        EnderscapeDamageTypes.register(context, STOMP);
    }

    private static void register(BootstrapContext<DamageType> context, ResourceKey<DamageType> key) {
        context.register(key, (Object)new DamageType(key.location().getPath(), DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f));
    }

    private static ResourceKey<DamageType> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Enderscape.id(name));
        DAMAGE_TYPES.add((ResourceKey<DamageType>)key);
        return key;
    }
}

