/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.DashJumpUser;
import net.bunten.enderscape.entity.DashJumpUserData;
import net.bunten.enderscape.entity.EndTrialSpawnable;
import net.bunten.enderscape.entity.EndTrialSpawnableData;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.network.ClientboundDashJumpDataPayload;
import net.bunten.enderscape.network.ClientboundEndTrialSpawnableDataPayload;
import net.bunten.enderscape.network.ClientboundMagniaDataPayload;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.GAME)
public class EnderscapeDataAttachments {
    public static final Supplier<AttachmentType<MagniaMovingData>> MAGNIA_MOVING_DATA = EnderscapeDataAttachments.register("magnia_moving_data", () -> AttachmentType.builder(() -> new MagniaMovingData(0L)).serialize(MagniaMovingData.CODEC).build());
    public static final Supplier<AttachmentType<DashJumpUserData>> DASH_JUMP_USER_DATA = EnderscapeDataAttachments.register("dash_jump_user_data", () -> AttachmentType.builder(() -> new DashJumpUserData(false, 0)).serialize(DashJumpUserData.CODEC).build());
    public static final Supplier<AttachmentType<EndTrialSpawnableData>> END_TRIAL_SPAWNABLE_DATA = EnderscapeDataAttachments.register("end_trial_spawnable_data", () -> AttachmentType.builder(() -> new EndTrialSpawnableData(false)).serialize(EndTrialSpawnableData.CODEC).build());

    @SubscribeEvent
    public static void onEntityStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (!player.level().isClientSide()) {
            Record data;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target instanceof DashJumpUser) {
                data = (DashJumpUserData)target.getData(DASH_JUMP_USER_DATA.get());
                serverPlayer.connection.send((CustomPacketPayload)new ClientboundDashJumpDataPayload(target.getId(), (DashJumpUserData)data));
            }
            if (target instanceof MagniaMoveable) {
                data = (MagniaMovingData)target.getData(MAGNIA_MOVING_DATA.get());
                serverPlayer.connection.send((CustomPacketPayload)new ClientboundMagniaDataPayload(target.getId(), (MagniaMovingData)data));
            }
            if (target instanceof EndTrialSpawnable) {
                data = (EndTrialSpawnableData)target.getData(END_TRIAL_SPAWNABLE_DATA.get());
                serverPlayer.connection.send((CustomPacketPayload)new ClientboundEndTrialSpawnableDataPayload(target.getId(), (EndTrialSpawnableData)data));
            }
        }
    }

    private static <T> Supplier<AttachmentType<T>> register(String name, Supplier<AttachmentType<T>> entry) {
        return RegistryHelper.register(NeoForgeRegistries.ATTACHMENT_TYPES, Enderscape.id(name), entry);
    }
}

