/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.mojang.serialization.Codec;
import java.util.function.UnaryOperator;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.item.component.DashJump;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.ExtraCodecs;

public class EnderscapeDataComponents {
    public static final DataComponentType<DashJump> DASH_JUMP = EnderscapeDataComponents.register("dash_jump", builder -> builder.persistent(DashJump.CODEC).networkSynchronized(DashJump.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Boolean> ENABLED = EnderscapeDataComponents.register("enabled", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<Integer> ENTITIES_PULLED = EnderscapeDataComponents.register("entities_pulled", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> ENTITIES_PULLED_TO_USE_FUEL = EnderscapeDataComponents.register("entities_pulled_to_use_fuel", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> ENTITY_PULL_RANGE = EnderscapeDataComponents.register("entity_pull_range", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> DISTANCE_FOR_COST_TO_INCREASE = EnderscapeDataComponents.register("distance_for_cost_to_increase", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> CURRENT_NEBULITE_FUEL = EnderscapeDataComponents.register("current_nebulite_fuel", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MAXIMUM_NEBULITE_FUEL = EnderscapeDataComponents.register("maximum_nebulite_fuel", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> NEBULITE_FUEL_PER_USE = EnderscapeDataComponents.register("nebulite_fuel_per_use", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));

    private static <T> DataComponentType<T> register(String string, UnaryOperator<DataComponentType.Builder<T>> unaryOperator) {
        DataComponentType type = ((DataComponentType.Builder)unaryOperator.apply(DataComponentType.builder())).build();
        RegistryHelper.register(BuiltInRegistries.DATA_COMPONENT_TYPE, Enderscape.id(string), () -> type);
        return type;
    }
}

