/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public class EnderscapeDensityFunctionTypes {
    static final Codec<Double> NOISE_VALUE_CODEC = Codec.doubleRange((double)-1000000.0, (double)1000000.0);

    private static MapCodec<? extends DensityFunction> register(String string, KeyDispatchDataCodec<? extends DensityFunction> dispatch) {
        MapCodec codec = dispatch.codec();
        RegistryHelper.register(BuiltInRegistries.DENSITY_FUNCTION_TYPE, Enderscape.id(string), () -> codec);
        return codec;
    }

    static {
        EnderscapeDensityFunctionTypes.register("distance_from_center_gradient", DistanceFromCenterGradient.CODEC);
    }

    record DistanceFromCenterGradient(int minDistance, int maxDistance, double fromValue, double toValue) implements DensityFunction.SimpleFunction
    {
        private static final MapCodec<DistanceFromCenterGradient> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_distance").forGetter(DistanceFromCenterGradient::minDistance), (App)Codec.INT.fieldOf("max_distance").forGetter(DistanceFromCenterGradient::maxDistance), (App)NOISE_VALUE_CODEC.fieldOf("from_value").forGetter(DistanceFromCenterGradient::fromValue), (App)NOISE_VALUE_CODEC.fieldOf("to_value").forGetter(DistanceFromCenterGradient::toValue)).apply((Applicative)instance, DistanceFromCenterGradient::new));
        public static final KeyDispatchDataCodec<DistanceFromCenterGradient> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);

        public double compute(DensityFunction.FunctionContext context) {
            float f = context.blockX();
            float h = context.blockZ();
            float distance = Mth.sqrt((float)(f * f + h * h));
            return Mth.clampedMap((double)distance, (double)this.minDistance, (double)this.maxDistance, (double)this.fromValue, (double)this.toValue);
        }

        public double minValue() {
            return Math.min(this.fromValue, this.toValue);
        }

        public double maxValue() {
            return Math.max(this.fromValue, this.toValue);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }
}

