/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.level.Level;

public class EnderscapeEnchantments {
    public static final List<ResourceKey<Enchantment>> ENCHANTMENTS = new ArrayList<ResourceKey<Enchantment>>();
    public static final ResourceKey<Enchantment> LIGHTSPEED = EnderscapeEnchantments.register("lightspeed");
    public static final ResourceKey<Enchantment> REBOUND = EnderscapeEnchantments.register("rebound");
    public static final ResourceKey<Enchantment> TRANSDIMENSIONAL = EnderscapeEnchantments.register("transdimensional");

    public void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        EnderscapeEnchantments.register(context, LIGHTSPEED, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(EnderscapeItemTags.MIRROR_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withSpecialEffect(EnderscapeEnchantmentEffectComponents.MIRROR_DISTANCE_FOR_COST_INCREASE.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)250.0f))));
        EnderscapeEnchantments.register(context, REBOUND, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(EnderscapeItemTags.ELYTRA_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.CHEST})));
        EnderscapeEnchantments.register(context, TRANSDIMENSIONAL, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(EnderscapeItemTags.MIRROR_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }

    private static ResourceKey<Enchantment> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)Enderscape.id(name));
        ENCHANTMENTS.add((ResourceKey<Enchantment>)key);
        return key;
    }

    public static boolean hasRebound(Level level, ItemStack stack) {
        try {
            HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Optional enchantment = registry.get(REBOUND);
            return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchantment.get()), (ItemStack)stack) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

