/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.google.common.reflect.Reflection;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.ai.EnderscapeSensors;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.bunten.enderscape.entity.drifter.Driftlet;
import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.bunten.enderscape.entity.rustle.Rustle;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeEntities {
    public static final DeferredHolder<EntityType<?>, EntityType<Drifter>> DRIFTER = EnderscapeEntities.register("drifter", () -> EntityType.Builder.of(Drifter::new, (MobCategory)MobCategory.CREATURE).sized(1.9f, 2.9f).eyeHeight(1.08f).passengerAttachments(new float[]{3.0f}).ridingOffset(0.1f).clientTrackingRange(8));
    public static final DeferredHolder<EntityType<?>, EntityType<Driftlet>> DRIFTLET = EnderscapeEntities.register("driftlet", () -> EntityType.Builder.of(Driftlet::new, (MobCategory)MobCategory.CREATURE).sized(1.15f, 1.3f).eyeHeight(0.5f).passengerAttachments(new float[]{2.5f}).ridingOffset(0.1f).clientTrackingRange(8));
    public static final DeferredHolder<EntityType<?>, EntityType<Rubblemite>> RUBBLEMITE = EnderscapeEntities.register("rubblemite", () -> EntityType.Builder.of(Rubblemite::new, (MobCategory)MobCategory.MONSTER).sized(0.55f, 0.4f).eyeHeight(0.13f).passengerAttachments(new float[]{0.3f}).ridingOffset(0.1f).clientTrackingRange(8));
    public static final DeferredHolder<EntityType<?>, EntityType<Rustle>> RUSTLE = EnderscapeEntities.register("rustle", () -> EntityType.Builder.of(Rustle::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.5f).eyeHeight(0.13f).passengerAttachments(new float[]{0.3f}).ridingOffset(0.1f).clientTrackingRange(8));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> builder) {
        return EnderscapeEntities.register(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Enderscape.id(name)), builder);
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(ResourceKey<EntityType<?>> resourceKey, Supplier<EntityType.Builder<T>> builder) {
        return RegistryHelper.registerForHolder(BuiltInRegistries.ENTITY_TYPE, resourceKey, () -> ((EntityType.Builder)builder.get()).build(resourceKey.location().toString()));
    }

    @SubscribeEvent
    public static void entityAttributeCreationListener(EntityAttributeCreationEvent event) {
        event.put((EntityType)DRIFTER.get(), Drifter.createAttributes().build());
        event.put((EntityType)DRIFTLET.get(), Driftlet.createAttributes().build());
        event.put((EntityType)RUBBLEMITE.get(), Rubblemite.createAttributes().build());
        event.put((EntityType)RUSTLE.get(), Rustle.createAttributes().build());
    }

    @SubscribeEvent
    public static void spawnPlacementsListener(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DRIFTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AbstractDrifter::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)DRIFTLET.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AbstractDrifter::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)RUBBLEMITE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Rubblemite::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)RUSTLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Rustle::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    static {
        Reflection.initialize((Class[])new Class[]{EnderscapeMemory.class, EnderscapeSensors.class});
    }
}

