/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.item.CrackedMirrorItem;
import net.bunten.enderscape.item.DriftJellyBottleItem;
import net.bunten.enderscape.item.DriftLeggingsItem;
import net.bunten.enderscape.item.HealingItem;
import net.bunten.enderscape.item.MagniaAttractorItem;
import net.bunten.enderscape.item.MirrorItem;
import net.bunten.enderscape.item.NebuliteItem;
import net.bunten.enderscape.item.RubbleShieldItem;
import net.bunten.enderscape.item.RustleBucketItem;
import net.bunten.enderscape.item.component.DashJump;
import net.bunten.enderscape.registry.EnderscapeBannerPatterns;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeJukeboxSongs;
import net.bunten.enderscape.registry.EnderscapeMobEffects;
import net.bunten.enderscape.registry.EnderscapeTrimPatterns;
import net.bunten.enderscape.registry.RegistryHelper;
import net.bunten.enderscape.registry.tag.EnderscapeBannerPatternTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;

public class EnderscapeItems {
    private static final ItemAttributeModifiers DRIFT_LEGGINGS_ATTRIBUTES = ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(Enderscape.id("drift_leggings_armor"), 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.LEGS).add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(Enderscape.id("drift_leggings_armor_toughness"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.LEGS).add(Attributes.MOVEMENT_SPEED, new AttributeModifier(Enderscape.id("drift_leggings_movement_speed"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.LEGS).add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Enderscape.id("drift_leggings_safe_fall_distance"), 0.6, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.LEGS).add(Attributes.GRAVITY, new AttributeModifier(Enderscape.id("drift_leggings_gravity"), -0.4, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.LEGS).build();
    public static final Holder<ArmorMaterial> DRIFT_LEGGINGS_MATERIAL = EnderscapeItems.registerArmorMaterial(Enderscape.id("drift_leggings"), (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, 0);
        enumMap.put(ArmorItem.Type.LEGGINGS, 0);
        enumMap.put(ArmorItem.Type.CHESTPLATE, 0);
        enumMap.put(ArmorItem.Type.HELMET, 0);
        enumMap.put(ArmorItem.Type.BODY, 0);
    }), 20, EnderscapeItemSounds.DRIFT_LEGGINGS_EQUIP, 0.0f, 0.0f, () -> Ingredient.of(EnderscapeItemTags.REPAIRS_DRIFT_LEGGINGS));
    public static final Supplier<Item> DRIFTER_SPAWN_EGG = EnderscapeItems.registerSpawnEgg(EnderscapeEntities.DRIFTER, 15302655, 7689384);
    public static final Supplier<Item> DRIFTLET_SPAWN_EGG = EnderscapeItems.registerSpawnEgg(EnderscapeEntities.DRIFTLET, 0xFFAAF9, 15302655);
    public static final Supplier<Item> RUBBLEMITE_SPAWN_EGG = EnderscapeItems.registerSpawnEgg(EnderscapeEntities.RUBBLEMITE, 15924670, 12695175);
    public static final Supplier<Item> RUSTLE_SPAWN_EGG = EnderscapeItems.registerSpawnEgg(EnderscapeEntities.RUSTLE, 15131119, 11905990);
    public static final Supplier<Item> RUSTLE_BUCKET = EnderscapeItems.registerItem("rustle_bucket", RustleBucketItem::new, new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY));
    public static final Supplier<Item> VEILED_HANGING_SIGN_ITEM = EnderscapeItems.registerItem("veiled_hanging_sign", (Item.Properties properties) -> new HangingSignItem(EnderscapeBlocks.VEILED_HANGING_SIGN.get(), EnderscapeBlocks.VEILED_WALL_HANGING_SIGN.get(), properties), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> VEILED_SIGN_ITEM = EnderscapeItems.registerItem("veiled_sign", (Item.Properties properties) -> new SignItem(properties, EnderscapeBlocks.VEILED_SIGN.get(), EnderscapeBlocks.VEILED_WALL_SIGN.get()), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> CELESTIAL_HANGING_SIGN_ITEM = EnderscapeItems.registerItem("celestial_hanging_sign", (Item.Properties properties) -> new HangingSignItem(EnderscapeBlocks.CELESTIAL_HANGING_SIGN.get(), EnderscapeBlocks.CELESTIAL_WALL_HANGING_SIGN.get(), properties), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> CELESTIAL_SIGN_ITEM = EnderscapeItems.registerItem("celestial_sign", (Item.Properties properties) -> new SignItem(properties, EnderscapeBlocks.CELESTIAL_SIGN.get(), EnderscapeBlocks.CELESTIAL_WALL_SIGN.get()), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> MURUBLIGHT_HANGING_SIGN_ITEM = EnderscapeItems.registerItem("murublight_hanging_sign", (Item.Properties properties) -> new HangingSignItem(EnderscapeBlocks.MURUBLIGHT_HANGING_SIGN.get(), EnderscapeBlocks.MURUBLIGHT_WALL_HANGING_SIGN.get(), properties), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> MURUBLIGHT_SIGN_ITEM = EnderscapeItems.registerItem("murublight_sign", (Item.Properties properties) -> new SignItem(properties, EnderscapeBlocks.MURUBLIGHT_SIGN.get(), EnderscapeBlocks.MURUBLIGHT_WALL_SIGN.get()), new Item.Properties().stacksTo(16));
    public static final Supplier<Item> CHORUS_CAKE_ROLL_ITEM = EnderscapeItems.registerItem("chorus_cake_roll", (Item.Properties properties) -> new BlockItem(EnderscapeBlocks.CHORUS_CAKE_ROLL.get(), properties), new Item.Properties().stacksTo(1));
    public static final Supplier<Item> BLINKLIGHT = EnderscapeItems.registerItem("blinklight", (Item.Properties properties) -> new ItemNameBlockItem(EnderscapeBlocks.BLINKLIGHT_VINES_HEAD.get(), properties), new Item.Properties());
    public static final Supplier<Item> DRIFT_JELLY_BOTTLE = EnderscapeItems.registerItem("drift_jelly_bottle", DriftJellyBottleItem::new, new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).food(new FoodProperties.Builder().alwaysEdible().nutrition(6).saturationModifier(0.2f).effect(() -> new MobEffectInstance(EnderscapeMobEffects.LOW_GRAVITY, 400), 1.0f).build()).stacksTo(16));
    public static final Supplier<Item> FLANGER_BERRY = EnderscapeItems.registerItem("flanger_berry", (Item.Properties properties) -> new ItemNameBlockItem(EnderscapeBlocks.FLANGER_BERRY_VINE.get(), properties), new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(1.2f).build()));
    public static final Supplier<Item> MURUBLIGHT_SHELF_ITEM = EnderscapeItems.registerItem("murublight_shelf", (Item.Properties properties) -> new BlockItem(EnderscapeBlocks.MURUBLIGHT_SHELF.get(), properties), new Item.Properties().food(new FoodProperties.Builder().alwaysEdible().nutrition(4).saturationModifier(0.3f).effect(new MobEffectInstance(MobEffects.POISON, 200), 1.0f).build()));
    public static final Supplier<Item> END_CITY_KEY = EnderscapeItems.registerItem("end_city_key");
    public static final Supplier<Item> RUBBLE_CHITIN = EnderscapeItems.registerItem("rubble_chitin");
    public static final Supplier<Item> NEBULITE = EnderscapeItems.registerItem("nebulite", NebuliteItem::new, new Item.Properties());
    public static final Supplier<Item> NEBULITE_SHARDS = EnderscapeItems.registerItem("nebulite_shards");
    public static final Supplier<Item> RAW_SHADOLINE = EnderscapeItems.registerItem("raw_shadoline");
    public static final Supplier<Item> SHADOLINE_INGOT = EnderscapeItems.registerItem("shadoline_ingot");
    public static final Item.Properties RUBBLE_SHIELD_PROPERTIES = new Item.Properties().component(EnderscapeDataComponents.DASH_JUMP, (Object)new DashJump(60, 2.35f, 0.35f, 0.7f, EnderscapeItemSounds.RUBBLE_SHIELD_DASH, true)).durability(336);
    public static final Supplier<Item> END_STONE_RUBBLE_SHIELD = EnderscapeItems.registerItem("end_stone_rubble_shield", RubbleShieldItem::new, RUBBLE_SHIELD_PROPERTIES);
    public static final Supplier<Item> VERADITE_RUBBLE_SHIELD = EnderscapeItems.registerItem("veradite_rubble_shield", RubbleShieldItem::new, RUBBLE_SHIELD_PROPERTIES);
    public static final Supplier<Item> MIRESTONE_RUBBLE_SHIELD = EnderscapeItems.registerItem("mirestone_rubble_shield", RubbleShieldItem::new, RUBBLE_SHIELD_PROPERTIES);
    public static final Supplier<Item> KURODITE_RUBBLE_SHIELD = EnderscapeItems.registerItem("kurodite_rubble_shield", RubbleShieldItem::new, RUBBLE_SHIELD_PROPERTIES);
    public static final Supplier<Item> DRIFT_LEGGINGS = EnderscapeItems.registerItem("drift_leggings", DriftLeggingsItem::new, new Item.Properties().attributes(DRIFT_LEGGINGS_ATTRIBUTES).durability(495));
    public static final Supplier<Item> MAGNIA_ATTRACTOR = EnderscapeItems.registerItem("magnia_attractor", MagniaAttractorItem::new, new Item.Properties().component(EnderscapeDataComponents.ENABLED, (Object)true).component(EnderscapeDataComponents.ENTITIES_PULLED, (Object)0).component(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL, (Object)200).component(EnderscapeDataComponents.ENTITY_PULL_RANGE, (Object)10).component(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL, (Object)6).component(EnderscapeDataComponents.NEBULITE_FUEL_PER_USE, (Object)1));
    public static final Supplier<Item> CRACKED_MIRROR = EnderscapeItems.registerItem("cracked_mirror", CrackedMirrorItem::new, new Item.Properties().rarity(Rarity.EPIC).stacksTo(1));
    public static final Supplier<Item> MIRROR = EnderscapeItems.registerItem("mirror", MirrorItem::new, new Item.Properties().component(EnderscapeDataComponents.DISTANCE_FOR_COST_TO_INCREASE, (Object)500).component(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL, (Object)5).component(EnderscapeDataComponents.NEBULITE_FUEL_PER_USE, (Object)1).rarity(Rarity.EPIC));
    public static final Supplier<Item> CRESCENT_BANNER_PATTERN = EnderscapeItems.registerItem("crescent_banner_pattern", (Item.Properties properties) -> new BannerPatternItem(EnderscapeBannerPatternTags.PATTERN_ITEM_CRESCENT, properties), new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    public static final Supplier<Item> STASIS_ARMOR_TRIM_SMITHING_TEMPLATE = EnderscapeItems.registerItem("stasis_armor_trim_smithing_template", (Item.Properties properties) -> SmithingTemplateItem.createArmorTrimTemplate(EnderscapeTrimPatterns.STASIS, (FeatureFlag[])new FeatureFlag[0]), new Item.Properties());
    public static final Supplier<Item> MUSIC_DISC_GLARE = EnderscapeItems.registerMusicDisc(EnderscapeJukeboxSongs.GLARE, Rarity.RARE);
    public static final Supplier<Item> MUSIC_DISC_BLISS = EnderscapeItems.registerMusicDisc(EnderscapeJukeboxSongs.BLISS, Rarity.RARE);
    public static final Supplier<Item> MUSIC_DISC_DECAY = EnderscapeItems.registerMusicDisc(EnderscapeJukeboxSongs.DECAY, Rarity.UNCOMMON);
    public static final Supplier<Item> HEALING = EnderscapeItems.registerItem("healing", HealingItem::new, new Item.Properties());

    private static Holder<ArmorMaterial> registerArmorMaterial(ResourceLocation location, EnumMap<ArmorItem.Type, Integer> enumMap, int i, Holder<SoundEvent> holder, float f, float g, Supplier<Ingredient> supplier) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(location));
        return RegistryHelper.registerForHolder(BuiltInRegistries.ARMOR_MATERIAL, location, () -> new ArmorMaterial((Map)enumMap, i, holder, supplier, list, f, g));
    }

    private static <T extends Mob> Supplier<Item> registerSpawnEgg(DeferredHolder<EntityType<?>, EntityType<T>> type, int color1, int color2) {
        Object name = type.getId().getPath() + "_spawn_egg";
        name = ((String)name).replace("entity.enderscape.", "");
        return EnderscapeItems.registerItem((String)name, (Item.Properties properties) -> new DeferredSpawnEggItem((Supplier)type, color1, color2, properties), new Item.Properties());
    }

    private static Supplier<Item> registerMusicDisc(ResourceKey<JukeboxSong> song, Rarity rarity) {
        return EnderscapeItems.registerItem("music_disc_" + song.location().getPath(), Item::new, new Item.Properties().stacksTo(1).rarity(rarity).jukeboxPlayable(song));
    }

    private static ResourceKey<Item> createResourceKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Enderscape.id(name));
    }

    private static ResourceKey<Item> blockIdToItemId(ResourceKey<Block> resourceKey) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceKey.location());
    }

    public static Supplier<Item> registerBlock(Supplier<Block> block, ResourceKey<Block> key) {
        return EnderscapeItems.registerBlock(block, key, BlockItem::new, new Item.Properties());
    }

    public static Supplier<Item> registerBlock(Supplier<Block> block, ResourceKey<Block> key, BiFunction<Block, Item.Properties, Item> biFunction, Item.Properties properties) {
        return EnderscapeItems.registerItem(EnderscapeItems.blockIdToItemId(key), (Item.Properties propertiesx) -> (Item)biFunction.apply((Block)block.get(), (Item.Properties)propertiesx), properties);
    }

    public static Supplier<Item> registerItem(String string, Function<Item.Properties, Item> function, Item.Properties properties) {
        return EnderscapeItems.registerItem(EnderscapeItems.createResourceKey(string), function, properties);
    }

    public static Supplier<Item> registerItem(String string) {
        return EnderscapeItems.registerItem(EnderscapeItems.createResourceKey(string), Item::new, new Item.Properties());
    }

    public static Supplier<Item> registerItem(ResourceKey<Item> resourceKey, Function<Item.Properties, Item> function, Item.Properties properties) {
        return RegistryHelper.register(BuiltInRegistries.ITEM, resourceKey, () -> {
            Item item = (Item)function.apply(properties);
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.registerBlocks(Item.BY_BLOCK, item);
            }
            return item;
        });
    }

    public static ItemStack getEndVaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)EnderscapeBlocks.END_VAULT.get());
        CompoundTag keyItem = new CompoundTag();
        keyItem.putInt("count", 1);
        keyItem.putString("id", "enderscape:end_city_key");
        CompoundTag configTag = new CompoundTag();
        configTag.put("key_item", (Tag)keyItem);
        configTag.putString("loot_table", "enderscape:end_city/vault");
        CompoundTag blockEntityData = new CompoundTag();
        blockEntityData.putString("id", "minecraft:vault");
        blockEntityData.put("config", (Tag)configTag);
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityData));
        return stack;
    }

    public static ItemStack getEndCityBannerInstance(HolderGetter<BannerPattern> getter) {
        ItemStack stack = new ItemStack((ItemLike)Items.MAGENTA_BANNER);
        stack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().addIfRegistered(getter, BannerPatterns.STRIPE_SMALL, DyeColor.BLACK).addIfRegistered(getter, BannerPatterns.STRIPE_TOP, DyeColor.MAGENTA).addIfRegistered(getter, BannerPatterns.STRIPE_BOTTOM, DyeColor.MAGENTA).addIfRegistered(getter, BannerPatterns.STRIPE_MIDDLE, DyeColor.MAGENTA).addIfRegistered(getter, BannerPatterns.FLOWER, DyeColor.MAGENTA).addIfRegistered(getter, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.MAGENTA).addIfRegistered(getter, BannerPatterns.TRIANGLE_BOTTOM, DyeColor.BLACK).addIfRegistered(getter, BannerPatterns.TRIANGLE_TOP, DyeColor.BLACK).addIfRegistered(getter, BannerPatterns.CIRCLE_MIDDLE, DyeColor.BLACK).addIfRegistered(getter, EnderscapeBannerPatterns.CRESCENT, DyeColor.MAGENTA).build());
        stack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"block.enderscape.end_city_banner"));
        stack.set(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
        return stack;
    }
}

