/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeMusic;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;

public class EnderscapeJukeboxSongs {
    public static final List<ResourceKey<JukeboxSong>> JUKEBOX_SONGS = new ArrayList<ResourceKey<JukeboxSong>>();
    public static final ResourceKey<JukeboxSong> GLARE = EnderscapeJukeboxSongs.register("glare");
    public static final ResourceKey<JukeboxSong> DECAY = EnderscapeJukeboxSongs.register("decay");
    public static final ResourceKey<JukeboxSong> BLISS = EnderscapeJukeboxSongs.register("bliss");

    public void bootstrap(BootstrapContext<JukeboxSong> context) {
        EnderscapeJukeboxSongs.register(context, GLARE, EnderscapeMusic.MUSIC_DISC_GLARE, 235.0f, 10);
        EnderscapeJukeboxSongs.register(context, DECAY, EnderscapeMusic.MUSIC_DISC_DECAY, 97.0f, 1);
        EnderscapeJukeboxSongs.register(context, BLISS, EnderscapeMusic.MUSIC_DISC_BLISS, 272.0f, 15);
    }

    private static void register(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> key, Holder<SoundEvent> soundEvent, float length, int output) {
        context.register(key, (Object)new JukeboxSong(soundEvent, (Component)Component.translatable((String)("jukebox_song.enderscape." + key.location().getPath())), length, output));
    }

    private static ResourceKey<JukeboxSong> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)Enderscape.id(name));
        JUKEBOX_SONGS.add((ResourceKey<JukeboxSong>)key);
        return key;
    }
}

