/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class EnderscapeNoiseParameters {
    public static final List<ResourceKey<NormalNoise.NoiseParameters>> NOISE_PARAMETERS = new ArrayList<ResourceKey<NormalNoise.NoiseParameters>>();
    public static final ResourceKey<NormalNoise.NoiseParameters> CELESTIAL_SURFACE = EnderscapeNoiseParameters.createKey("celestial_surface");
    public static final ResourceKey<NormalNoise.NoiseParameters> CORRUPTION_CEILING = EnderscapeNoiseParameters.createKey("corruption_ceiling");
    public static final ResourceKey<NormalNoise.NoiseParameters> VEILED_SURFACE = EnderscapeNoiseParameters.createKey("veiled_surface");

    private static ResourceKey<NormalNoise.NoiseParameters> createKey(String string) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.NOISE, (ResourceLocation)Enderscape.id(string));
        NOISE_PARAMETERS.add((ResourceKey<NormalNoise.NoiseParameters>)key);
        return key;
    }

    public void bootstrap(BootstrapContext<NormalNoise.NoiseParameters> context) {
        EnderscapeNoiseParameters.register(context, CELESTIAL_SURFACE, new NormalNoise.NoiseParameters(-4, 1.0, new double[]{0.5, 1.0}));
        EnderscapeNoiseParameters.register(context, CORRUPTION_CEILING, new NormalNoise.NoiseParameters(-4, 1.0, new double[]{0.5, 1.0}));
        EnderscapeNoiseParameters.register(context, VEILED_SURFACE, new NormalNoise.NoiseParameters(-5, 1.0, new double[]{0.5, 1.0}));
    }

    private static void register(BootstrapContext<NormalNoise.NoiseParameters> context, ResourceKey<NormalNoise.NoiseParameters> key, NormalNoise.NoiseParameters object) {
        context.register(key, (Object)object);
    }
}

