/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class EnderscapePaintingVariants {
    public static final List<ResourceKey<PaintingVariant>> PAINTING_VARIANTS = new ArrayList<ResourceKey<PaintingVariant>>();
    public static final ResourceKey<PaintingVariant> GRAPE_STATIC = EnderscapePaintingVariants.register("grape_static");

    public EnderscapePaintingVariants() {
        RegistryHelper.checkAllReady();
    }

    public void bootstrap(BootstrapContext<PaintingVariant> context) {
        this.register(context, GRAPE_STATIC, 3, 3);
    }

    private void register(BootstrapContext<PaintingVariant> context, ResourceKey<PaintingVariant> key, int width, int height) {
        context.register(key, (Object)new PaintingVariant(width, height, key.location()));
    }

    private static ResourceKey<PaintingVariant> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)Enderscape.id(name));
        PAINTING_VARIANTS.add((ResourceKey<PaintingVariant>)key);
        return key;
    }
}

