/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.particle.DashJumpShockwaveParticleOptions;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class EnderscapeParticles {
    public static final Supplier<SimpleParticleType> ALLURING_MAGNIA = EnderscapeParticles.register("alluring_magnia", true);
    public static final Supplier<SimpleParticleType> BLINKLIGHT_SPORES = EnderscapeParticles.register("blinklight_spores", false);
    public static final Supplier<SimpleParticleType> CELESTIAL_SPORES = EnderscapeParticles.register("celestial_spores", false);
    public static final Supplier<SimpleParticleType> CHORUS_POLLEN = EnderscapeParticles.register("chorus_pollen", false);
    public static final Supplier<SimpleParticleType> CORRUPT_SPORES = EnderscapeParticles.register("corrupt_spores", false);
    public static final Supplier<ParticleType<DashJumpShockwaveParticleOptions>> DASH_JUMP_SHOCKWAVE = EnderscapeParticles.register("dash_jump_shockwave", true, type -> DashJumpShockwaveParticleOptions.CODEC, type -> DashJumpShockwaveParticleOptions.STREAM_CODEC);
    public static final Supplier<SimpleParticleType> DASH_JUMP_SPARKS = EnderscapeParticles.register("dash_jump_sparks", true);
    public static final Supplier<SimpleParticleType> DRIFT_JELLY_DRIPPING = EnderscapeParticles.register("drift_jelly_dripping", true);
    public static final Supplier<SimpleParticleType> ENDER_PEARL = EnderscapeParticles.register("ender_pearl", true);
    public static final Supplier<SimpleParticleType> END_TRIAL_SPAWNER_DETECTION = EnderscapeParticles.register("end_trial_spawner_detection", true);
    public static final Supplier<SimpleParticleType> END_TRIAL_SPAWNER_EXHALE = EnderscapeParticles.register("end_trial_spawner_exhale", true);
    public static final Supplier<SimpleParticleType> END_VAULT_CONNECTION = EnderscapeParticles.register("end_vault_connection", true);
    public static final Supplier<SimpleParticleType> END_PORTAL_STARS = EnderscapeParticles.register("end_portal_stars", false);
    public static final Supplier<SimpleParticleType> MIRROR_TELEPORT_IN = EnderscapeParticles.register("mirror_teleport_in", true);
    public static final Supplier<SimpleParticleType> MIRROR_TELEPORT_OUT = EnderscapeParticles.register("mirror_teleport_out", true);
    public static final Supplier<SimpleParticleType> NEBULITE_ORE = EnderscapeParticles.register("nebulite_ore", true);
    public static final Supplier<SimpleParticleType> REPULSIVE_MAGNIA = EnderscapeParticles.register("repulsive_magnia", true);
    public static final Supplier<SimpleParticleType> RUSTLE_SLEEPING_BUBBLE = EnderscapeParticles.register("rustle_sleeping_bubble", true);
    public static final Supplier<SimpleParticleType> RUSTLE_SLEEPING_BUBBLE_POP = EnderscapeParticles.register("rustle_sleeping_bubble_pop", true);
    public static final Supplier<SimpleParticleType> VEILED_LEAVES = EnderscapeParticles.register("veiled_leaves", false);
    public static final Supplier<SimpleParticleType> VOID_POOF = EnderscapeParticles.register("void_poof", true);
    public static final Supplier<SimpleParticleType> VOID_STARS = EnderscapeParticles.register("void_stars", false);

    private static Supplier<SimpleParticleType> register(String name, boolean alwaysSpawn) {
        return RegistryHelper.register(BuiltInRegistries.PARTICLE_TYPE, Enderscape.id(name), () -> new SimpleParticleType(alwaysSpawn));
    }

    private static <T extends ParticleOptions> Supplier<ParticleType<T>> register(String name, boolean overrideLimiter, final Function<ParticleType<T>, MapCodec<T>> codecFunction, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecFunction) {
        return RegistryHelper.register(BuiltInRegistries.PARTICLE_TYPE, Enderscape.id(name), () -> new ParticleType<T>(overrideLimiter){

            public MapCodec<T> codec() {
                return (MapCodec)codecFunction.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodecFunction.apply(this);
            }
        });
    }
}

