/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeConfiguredFeatures;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class EnderscapePlacedFeatures {
    public static final List<ResourceKey<PlacedFeature>> PLACED_FEATURES = new ArrayList<ResourceKey<PlacedFeature>>();
    public static final ResourceKey<PlacedFeature> BLINKLIGHT_VINES = EnderscapePlacedFeatures.register("blinklight_vines");
    public static final ResourceKey<PlacedFeature> BULB_FLOWER = EnderscapePlacedFeatures.register("bulb_flower_patches");
    public static final ResourceKey<PlacedFeature> CEILING_NEBULITE_ORE = EnderscapePlacedFeatures.register("ceiling_nebulite_ore");
    public static final ResourceKey<PlacedFeature> CELESTIAL_GROVE_VEGETATION = EnderscapePlacedFeatures.register("celestial_grove_vegetation");
    public static final ResourceKey<PlacedFeature> CELESTIAL_GROWTH = EnderscapePlacedFeatures.register("celestial_growth");
    public static final ResourceKey<PlacedFeature> CHORUS_PLANTS = EnderscapePlacedFeatures.register("chorus_plants");
    public static final ResourceKey<PlacedFeature> CHORUS_SPROUTS = EnderscapePlacedFeatures.register("chorus_sprouts");
    public static final ResourceKey<PlacedFeature> COMMMON_CEILING_NEBULITE_ORE = EnderscapePlacedFeatures.register("commmon_ceiling_nebulite_ore");
    public static final ResourceKey<PlacedFeature> COMMON_CHORUS_SPROUTS = EnderscapePlacedFeatures.register("common_chorus_sprouts");
    public static final ResourceKey<PlacedFeature> COMMON_DRY_END_GROWTH = EnderscapePlacedFeatures.register("common_dry_end_growth");
    public static final ResourceKey<PlacedFeature> CORRUPT_BARRENS_VEGETATION = EnderscapePlacedFeatures.register("corrupt_barrens_vegetation");
    public static final ResourceKey<PlacedFeature> DOWNWARD_CORRUPT_GROWTH = EnderscapePlacedFeatures.register("downward_corrupt_growth");
    public static final ResourceKey<PlacedFeature> DOWNWARD_REPULSIVE_MAGNIA_SPROUTS = EnderscapePlacedFeatures.register("downward_repulsive_magnia_sprouts");
    public static final ResourceKey<PlacedFeature> DOWNWARD_TALL_CORRUPT_GROWTH = EnderscapePlacedFeatures.register("downward_tall_corrupt_growth");
    public static final ResourceKey<PlacedFeature> DRY_END_GROWTH = EnderscapePlacedFeatures.register("dry_end_growth");
    public static final ResourceKey<PlacedFeature> KURODITE = EnderscapePlacedFeatures.register("kurodite");
    public static final ResourceKey<PlacedFeature> LARGE_CELESTIAL_CHANTERELLES = EnderscapePlacedFeatures.register("large_celestial_chanterelles");
    public static final ResourceKey<PlacedFeature> LARGE_MURUBLIGHT_CHANTERELLES = EnderscapePlacedFeatures.register("large_murublight_chanterelles");
    public static final ResourceKey<PlacedFeature> MAGNIA_ARCH = EnderscapePlacedFeatures.register("magnia_arch");
    public static final ResourceKey<PlacedFeature> MAGNIA_TOWER = EnderscapePlacedFeatures.register("magnia_tower");
    public static final ResourceKey<PlacedFeature> MIRESTONE_BLOBS = EnderscapePlacedFeatures.register("mirestone_blobs");
    public static final ResourceKey<PlacedFeature> MIRESTONE_PILLARS = EnderscapePlacedFeatures.register("mirestone_pillars");
    public static final ResourceKey<PlacedFeature> MURUBLIGHT_SHELF = EnderscapePlacedFeatures.register("murublight_shelf");
    public static final ResourceKey<PlacedFeature> NEBULITE_ORE = EnderscapePlacedFeatures.register("nebulite_ore");
    public static final ResourceKey<PlacedFeature> SCATTERED_SHADOLINE_ORE = EnderscapePlacedFeatures.register("scattered_shadoline_ore");
    public static final ResourceKey<PlacedFeature> SHADOLINE_ORE = EnderscapePlacedFeatures.register("shadoline_ore");
    public static final ResourceKey<PlacedFeature> SMALL_ISLANDS = EnderscapePlacedFeatures.register("sky_islands");
    public static final ResourceKey<PlacedFeature> SMALL_SKY_ISLANDS = EnderscapePlacedFeatures.register("small_sky_islands");
    public static final ResourceKey<PlacedFeature> UNCOMMON_CHORUS_PLANTS = EnderscapePlacedFeatures.register("uncommon_chorus_plants");
    public static final ResourceKey<PlacedFeature> UNCOMMON_CHORUS_SPROUTS = EnderscapePlacedFeatures.register("uncommon_chorus_sprouts");
    public static final ResourceKey<PlacedFeature> UNCOMMON_MURUBLIGHT_SHELF = EnderscapePlacedFeatures.register("uncommon_murublight_shelf");
    public static final ResourceKey<PlacedFeature> UPWARD_ALLURING_MAGNIA_SPROUTS = EnderscapePlacedFeatures.register("upward_alluring_magnia_sprouts");
    public static final ResourceKey<PlacedFeature> UPWARD_CORRUPT_GROWTH = EnderscapePlacedFeatures.register("upward_corrupt_growth");
    public static final ResourceKey<PlacedFeature> UPWARD_TALL_CORRUPT_GROWTH = EnderscapePlacedFeatures.register("upward_tall_corrupt_growth");
    public static final ResourceKey<PlacedFeature> VEILED_TREES = EnderscapePlacedFeatures.register("veiled_trees");
    public static final ResourceKey<PlacedFeature> VEILED_WOODLANDS_VEGETATION = EnderscapePlacedFeatures.register("veiled_woodlands_vegetation");
    public static final ResourceKey<PlacedFeature> VERADITE = EnderscapePlacedFeatures.register("veradite");
    public static final ResourceKey<PlacedFeature> VOID_SHALE = EnderscapePlacedFeatures.register("void_shale");
    public static final ResourceKey<PlacedFeature> VOID_SHALE_BLOBS = EnderscapePlacedFeatures.register("void_shale_blobs");
    public static final ResourceKey<PlacedFeature> WISP_FLOWER_PATCHES = EnderscapePlacedFeatures.register("wisp_flower_patches");
    public final PlacementModifier aboveDepthsRange = HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.top());

    public EnderscapePlacedFeatures() {
        RegistryHelper.checkAllReady();
    }

    public void bootstrap(BootstrapContext<PlacedFeature> context) {
        this.registerVeiledWoodlands(context);
        this.registerMagniaCrags(context);
        this.registerCelestialGrove(context);
        this.registerCorruptBarrens(context);
        PlacementUtils.register(context, CHORUS_PLANTS, this.get(context, EndFeatures.CHORUS_PLANT), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)2, (int)4)), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, 1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, -1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(1, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-1, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 3, 1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 4, 1), (Block[])new Block[]{Blocks.AIR})})), BiomeFilter.biome()});
        PlacementUtils.register(context, UNCOMMON_CHORUS_PLANTS, this.get(context, EndFeatures.CHORUS_PLANT), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), RarityFilter.onAverageOnceEvery((int)4), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, 1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, -1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(1, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-1, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 3, 1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 4, 1), (Block[])new Block[]{Blocks.AIR})})), BiomeFilter.biome()});
        PlacementUtils.register(context, DRY_END_GROWTH, this.get(context, EnderscapeConfiguredFeatures.DRY_END_GROWTH), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, COMMON_DRY_END_GROWTH, this.get(context, EnderscapeConfiguredFeatures.DRY_END_GROWTH), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)3, (int)20)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, CHORUS_SPROUTS, this.get(context, EnderscapeConfiguredFeatures.CHORUS_SPROUTS), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, COMMON_CHORUS_SPROUTS, this.get(context, EnderscapeConfiguredFeatures.CHORUS_SPROUTS), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)4, (int)8)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, UNCOMMON_CHORUS_SPROUTS, this.get(context, EnderscapeConfiguredFeatures.CHORUS_SPROUTS), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), RarityFilter.onAverageOnceEvery((int)3), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, MURUBLIGHT_SHELF, this.get(context, EnderscapeConfiguredFeatures.MURUBLIGHT_SHELF), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)30), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, NEBULITE_ORE, this.get(context, EnderscapeConfiguredFeatures.NEBULITE_ORE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, BiomeFilter.biome(), CountPlacement.of((int)5), InSquarePlacement.spread()});
        PlacementUtils.register(context, CEILING_NEBULITE_ORE, this.get(context, EnderscapeConfiguredFeatures.CEILING_NEBULITE_ORE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, COMMMON_CEILING_NEBULITE_ORE, this.get(context, EnderscapeConfiguredFeatures.CEILING_NEBULITE_ORE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)9), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, SHADOLINE_ORE, this.get(context, EnderscapeConfiguredFeatures.SHADOLINE_ORE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)12), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, SCATTERED_SHADOLINE_ORE, this.get(context, EnderscapeConfiguredFeatures.SCATTERED_SHADOLINE_ORE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)6), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, VERADITE, this.get(context, EnderscapeConfiguredFeatures.VERADITE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)48), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, VOID_SHALE, this.get(context, EnderscapeConfiguredFeatures.VOID_SHALE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, RarityFilter.onAverageOnceEvery((int)2), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, VOID_SHALE_BLOBS, this.get(context, EnderscapeConfiguredFeatures.VOID_SHALE_BLOB), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)24), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, MIRESTONE_BLOBS, this.get(context, EnderscapeConfiguredFeatures.MIRESTONE_BLOB), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)24), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, SMALL_ISLANDS, this.get(context, EnderscapeConfiguredFeatures.ENDERSCAPE_ISLAND), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)14), PlacementUtils.countExtra((int)1, (float)0.25f, (int)1), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)55), (VerticalAnchor)VerticalAnchor.absolute((int)70)), BiomeFilter.biome()});
        PlacementUtils.register(context, SMALL_SKY_ISLANDS, this.get(context, EnderscapeConfiguredFeatures.ENDERSCAPE_ISLAND), (PlacementModifier[])new PlacementModifier[]{HeightRangePlacement.of((HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)230), (VerticalAnchor)VerticalAnchor.absolute((int)260))), RarityFilter.onAverageOnceEvery((int)30), InSquarePlacement.spread(), BiomeFilter.biome()});
    }

    private void registerVeiledWoodlands(BootstrapContext<PlacedFeature> context) {
        PlacementUtils.register(context, VEILED_WOODLANDS_VEGETATION, this.get(context, EnderscapeConfiguredFeatures.VEILED_WOODLANDS_VEGETATION), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)96, (int)128)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.VEILED_END_STONE.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, WISP_FLOWER_PATCHES, this.get(context, EnderscapeConfiguredFeatures.WISP_FLOWER_PATCH), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountOnEveryLayerPlacement.of((int)2), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.VEILED_END_STONE.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, VEILED_TREES, this.get(context, EnderscapeConfiguredFeatures.VEILED_TREE), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)2), RarityFilter.onAverageOnceEvery((int)1), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, 0), (Block[])new Block[]{Blocks.AIR})), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.VEILED_END_STONE.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), BiomeFilter.biome()});
    }

    private void registerMagniaCrags(BootstrapContext<PlacedFeature> context) {
        PlacementUtils.register(context, UPWARD_ALLURING_MAGNIA_SPROUTS, this.get(context, EnderscapeConfiguredFeatures.UPWARD_ALLURING_MAGNIA_SPROUT), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)12), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])new Block[]{EnderscapeBlocks.ALLURING_MAGNIA.get()}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 1, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, 1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 0, -1), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(1, 0, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-1, 0, 0), (Block[])new Block[]{Blocks.AIR})})), BiomeFilter.biome()});
        PlacementUtils.register(context, DOWNWARD_REPULSIVE_MAGNIA_SPROUTS, this.get(context, EnderscapeConfiguredFeatures.DOWNWARD_REPULSIVE_MAGNIA_SPROUT), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)18), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.REPULSIVE_MAGNIA.get()})), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)32), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, MAGNIA_TOWER, this.get(context, EnderscapeConfiguredFeatures.MAGNIA_TOWER), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)1), RarityFilter.onAverageOnceEvery((int)3), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 3, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.not((BlockPredicate)BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -3, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, -5, -5), (Block[])new Block[]{Blocks.AIR})}))})), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE, EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.ALLURING_MAGNIA.get(), EnderscapeBlocks.REPULSIVE_MAGNIA.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, MAGNIA_ARCH, this.get(context, EnderscapeConfiguredFeatures.MAGNIA_ARCH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)1), RarityFilter.onAverageOnceEvery((int)2), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 3, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, 5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, 5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, 5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.not((BlockPredicate)BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -3, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(3, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(5, -5, -5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, 0), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, 3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-3, -5, -3), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, -5, 5), (Block[])new Block[]{Blocks.AIR}), BlockPredicate.matchesBlocks((Vec3i)new Vec3i(-5, -5, -5), (Block[])new Block[]{Blocks.AIR})}))})), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.END_STONE, EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.ALLURING_MAGNIA.get(), EnderscapeBlocks.REPULSIVE_MAGNIA.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
    }

    private void registerCelestialGrove(BootstrapContext<PlacedFeature> context) {
        PlacementUtils.register(context, BULB_FLOWER, this.get(context, EnderscapeConfiguredFeatures.BULB_FLOWER), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, NoiseBasedCountPlacement.of((int)80, (double)10.0, (double)-0.2), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.CELESTIAL_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, CELESTIAL_GROVE_VEGETATION, this.get(context, EnderscapeConfiguredFeatures.CELESTIAL_GROVE_VEGETATION), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)12), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.CELESTIAL_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, CELESTIAL_GROWTH, this.get(context, EnderscapeConfiguredFeatures.CELESTIAL_GROWTH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)60), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.CELESTIAL_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, LARGE_CELESTIAL_CHANTERELLES, this.get(context, EnderscapeConfiguredFeatures.LARGE_CELESTIAL_CHANTERELLE), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)1), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.CELESTIAL_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, 1, 0), (Block[])new Block[]{Blocks.AIR})), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, UNCOMMON_MURUBLIGHT_SHELF, this.get(context, EnderscapeConfiguredFeatures.MURUBLIGHT_SHELF), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountPlacement.of((int)15), BiomeFilter.biome(), InSquarePlacement.spread()});
    }

    private void registerCorruptBarrens(BootstrapContext<PlacedFeature> context) {
        PlacementUtils.register(context, MIRESTONE_PILLARS, this.get(context, EnderscapeConfiguredFeatures.MIRESTONE_PILLARS), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)60), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, KURODITE, this.get(context, EnderscapeConfiguredFeatures.KURODITE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)64), BiomeFilter.biome(), InSquarePlacement.spread()});
        PlacementUtils.register(context, BLINKLIGHT_VINES, this.get(context, EnderscapeConfiguredFeatures.BLINKLIGHT_VINES), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountPlacement.of((int)12), NoiseBasedCountPlacement.of((int)32, (double)4.0, (double)-0.36), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()})), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, CORRUPT_BARRENS_VEGETATION, this.get(context, EnderscapeConfiguredFeatures.CORRUPT_BARRENS_VEGETATION), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)6), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, DOWNWARD_CORRUPT_GROWTH, this.get(context, EnderscapeConfiguredFeatures.DOWNWARD_CORRUPT_GROWTH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountPlacement.of((int)256), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()})), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, DOWNWARD_TALL_CORRUPT_GROWTH, this.get(context, EnderscapeConfiguredFeatures.DOWNWARD_TALL_CORRUPT_GROWTH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountPlacement.of((int)25), NoiseBasedCountPlacement.of((int)35, (double)6.0, (double)0.0), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()})), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
        PlacementUtils.register(context, UPWARD_CORRUPT_GROWTH, this.get(context, EnderscapeConfiguredFeatures.UPWARD_CORRUPT_GROWTH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)70), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, UPWARD_TALL_CORRUPT_GROWTH, this.get(context, EnderscapeConfiguredFeatures.UPWARD_TALL_CORRUPT_GROWTH), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountOnEveryLayerPlacement.of((int)10), NoiseBasedCountPlacement.of((int)16, (double)4.0, (double)-0.36), BiomeFilter.biome(), InSquarePlacement.spread(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_OVERGROWTH.get()}), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))});
        PlacementUtils.register(context, LARGE_MURUBLIGHT_CHANTERELLES, this.get(context, EnderscapeConfiguredFeatures.DOWNWARD_LARGE_MURUBLIGHT_CHANTERELLE), (PlacementModifier[])new PlacementModifier[]{this.aboveDepthsRange, CountPlacement.of((int)8), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{EnderscapeBlocks.CORRUPT_OVERGROWTH.get()})), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])new Block[]{Blocks.AIR})), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
    }

    private Holder.Reference<ConfiguredFeature<?, ?>> get(BootstrapContext<PlacedFeature> context, ResourceKey<ConfiguredFeature<?, ?>> key) {
        return context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(key);
    }

    private static ResourceKey<PlacedFeature> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Enderscape.id(name));
        PLACED_FEATURES.add((ResourceKey<PlacedFeature>)key);
        return key;
    }
}

