/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeMobEffects;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.GAME)
public class EnderscapePotions {
    public static final Holder<Potion> LOW_GRAVITY = EnderscapePotions.register("low_gravity", () -> new Potion("low_gravity", new MobEffectInstance[]{new MobEffectInstance(EnderscapeMobEffects.LOW_GRAVITY, 1200)}));
    public static final Holder<Potion> LONG_LOW_GRAVITY = EnderscapePotions.register("long_low_gravity", () -> new Potion("low_gravity", new MobEffectInstance[]{new MobEffectInstance(EnderscapeMobEffects.LOW_GRAVITY, 2400)}));
    public static final Holder<Potion> STRONG_LOW_GRAVITY = EnderscapePotions.register("strong_low_gravity", () -> new Potion("low_gravity", new MobEffectInstance[]{new MobEffectInstance(EnderscapeMobEffects.LOW_GRAVITY, 200, 1)}));

    private static Holder<Potion> register(String name, Supplier<Potion> potion) {
        return RegistryHelper.registerForHolder(BuiltInRegistries.POTION, Enderscape.id(name), potion);
    }

    @SubscribeEvent
    public static void registerRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, EnderscapeItems.DRIFT_JELLY_BOTTLE.get(), LOW_GRAVITY);
        builder.addMix(LOW_GRAVITY, Items.REDSTONE, LONG_LOW_GRAVITY);
        builder.addMix(LOW_GRAVITY, Items.GLOWSTONE_DUST, STRONG_LOW_GRAVITY);
    }
}

