/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.function.Predicate;
import net.bunten.enderscape.client.registry.EnderscapeClientNetworking;
import net.bunten.enderscape.network.ClientboundDashJumpDataPayload;
import net.bunten.enderscape.network.ClientboundDashJumpPayload;
import net.bunten.enderscape.network.ClientboundDashJumpSoundPayload;
import net.bunten.enderscape.network.ClientboundEndTrialSpawnableDataPayload;
import net.bunten.enderscape.network.ClientboundMagniaDataPayload;
import net.bunten.enderscape.network.ClientboundMirrorTeleportInfoPayload;
import net.bunten.enderscape.network.ClientboundNebuliteOreSoundPayload;
import net.bunten.enderscape.network.ClientboundRubbleShieldCooldownSoundPayload;
import net.bunten.enderscape.network.ClientboundStareOverlayPayload;
import net.bunten.enderscape.network.ClientboundStareSoundPayload;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeServerNetworking {
    public static void sendMirrorInfoPayload(ServerPlayer player, boolean isDifferentDimension) {
        player.connection.send((CustomPacketPayload)new ClientboundMirrorTeleportInfoPayload(isDifferentDimension));
    }

    public static void sendNebuliteOreSoundPayload(ServerLevel world, BlockPos pos) {
        Predicate<ServerPlayer> dimension = player -> player.level().dimension() == world.dimension() && player.blockPosition().closerThan((Vec3i)pos, 32.0);
        world.players().stream().filter(dimension).forEach(player -> player.connection.send((CustomPacketPayload)new ClientboundNebuliteOreSoundPayload(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos))));
    }

    public static void sendStareOverlayPayload(ServerPlayer player) {
        player.connection.send((CustomPacketPayload)new ClientboundStareOverlayPayload());
    }

    public static void sendStareSoundPayload(ServerPlayer player, int entityId) {
        player.connection.send((CustomPacketPayload)new ClientboundStareSoundPayload(entityId));
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(ClientboundDashJumpSoundPayload.TYPE, ClientboundDashJumpSoundPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveDashJumpSoundPayload(payload, ctx));
        registrar.playToClient(ClientboundDashJumpPayload.TYPE, ClientboundDashJumpPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveDashJumpPayload(payload, ctx));
        registrar.playToClient(ClientboundMirrorTeleportInfoPayload.TYPE, ClientboundMirrorTeleportInfoPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveMirrorTeleportPayload(payload, ctx));
        registrar.playToClient(ClientboundNebuliteOreSoundPayload.TYPE, ClientboundNebuliteOreSoundPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveNebuliteOreSoundPayload(payload, ctx));
        registrar.playToClient(ClientboundRubbleShieldCooldownSoundPayload.TYPE, ClientboundRubbleShieldCooldownSoundPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveRubbleShieldCooldownSoundPayload(payload, ctx));
        registrar.playToClient(ClientboundStareOverlayPayload.TYPE, ClientboundStareOverlayPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveStareOverlayPayload(payload, ctx));
        registrar.playToClient(ClientboundStareSoundPayload.TYPE, ClientboundStareSoundPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveStareSoundPayload(payload, ctx));
        registrar.playToClient(ClientboundStructureChangedPayload.TYPE, ClientboundStructureChangedPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveStructureChangedPayload(payload, ctx));
        registrar.playToClient(ClientboundTransdimensionalTravelSoundPayload.TYPE, ClientboundTransdimensionalTravelSoundPayload.STREAM_CODEC, (payload, ctx) -> EnderscapeClientNetworking.receiveTransdimensionalTravelSoundPayload(payload, ctx));
        registrar.playToClient(ClientboundMagniaDataPayload.TYPE, ClientboundMagniaDataPayload.STREAM_CODEC, (payload, ctx) -> ClientboundMagniaDataPayload.handle(payload, ctx));
        registrar.playToClient(ClientboundDashJumpDataPayload.TYPE, ClientboundDashJumpDataPayload.STREAM_CODEC, (payload, ctx) -> ClientboundDashJumpDataPayload.handle(payload, ctx));
        registrar.playToClient(ClientboundEndTrialSpawnableDataPayload.TYPE, ClientboundEndTrialSpawnableDataPayload.STREAM_CODEC, (payload, ctx) -> ClientboundEndTrialSpawnableDataPayload.handle(payload, ctx));
    }
}

