/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.biome.util.SkyParameters;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.util.RGBA;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class EnderscapeSkyParameters {
    public static final List<ResourceKey<SkyParameters>> SKY_PARAMETERS = new ArrayList<ResourceKey<SkyParameters>>();

    public void bootstrap(BootstrapContext<SkyParameters> context) {
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.CELESTIAL_GROVE, 8869443, 0.0575f, 16754057, 0.168f, 2.0f, 1.0f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.CORRUPT_BARRENS, RGBA.darkenColor(8084382, 0.65f), 0.05f, RGBA.darkenColor(8084382, 0.65f), 0.12f, 4.0f, 1.25f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.MAGNIA_CRAGS, 9874846, 0.025f, 9043925, 0.102f, 1.0f, 1.0f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.VEILED_WOODLANDS, 9870250, 0.035f, 11834367, 0.12f, 4.0f, 1.0f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.VOID_DEPTHS, RGBA.darkenColor(8084382, 0.35f), 0.05f, RGBA.darkenColor(15305215, 0.35f), 0.12f, 4.0f, 2.0f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.VOID_SKIES, RGBA.darkenColor(8084382, 0.35f), 0.05f, RGBA.darkenColor(15305215, 0.35f), 0.12f, 4.0f, 2.0f);
        EnderscapeSkyParameters.register(context, EnderscapeBiomes.VOID_SKY_ISLANDS, RGBA.darkenColor(8084382, 0.35f), 0.05f, RGBA.darkenColor(15305215, 0.35f), 0.12f, 4.0f, 2.0f);
    }

    private static void register(BootstrapContext<SkyParameters> context, ResourceKey<Biome> biome, int nebulaColor, float nebulaAlpha, int starColor, float starAlpha, float fogStartDensity, float fogEndDensity) {
        context.register(EnderscapeSkyParameters.register(biome.location()), (Object)new SkyParameters(biome.location(), nebulaColor, nebulaAlpha, starColor, starAlpha, fogStartDensity, fogEndDensity));
    }

    private static ResourceKey<SkyParameters> register(ResourceLocation location) {
        ResourceKey key = ResourceKey.create(EnderscapeRegistries.SKY_PARAMETERS_KEY, (ResourceLocation)location);
        SKY_PARAMETERS.add((ResourceKey<SkyParameters>)key);
        return key;
    }
}

