/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.block.sound.SoundTypeOverride;
import net.bunten.enderscape.registry.EnderscapeSoundTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class EnderscapeSoundTypeOverrides {
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();
    public static final List<SoundTypeOverride> SOUND_TYPE_OVERRIDES = new ArrayList<SoundTypeOverride>();
    private static final List<BlockState> IGNORED_STATES = new ArrayList<BlockState>();
    private static final Map<BlockState, SoundType> SOUND_TYPE_CACHE = new IdentityHashMap<BlockState, SoundType>();

    public static Optional<SoundType> getSoundType(BlockState state) {
        if (IGNORED_STATES.contains(state)) {
            return Optional.empty();
        }
        return Optional.ofNullable(SOUND_TYPE_CACHE.computeIfAbsent(state, s -> {
            for (SoundTypeOverride override : SOUND_TYPE_OVERRIDES) {
                if (!override.applies((BlockState)s)) continue;
                return override.getSoundType();
            }
            IGNORED_STATES.add((BlockState)s);
            return null;
        }));
    }

    public static void register(SoundTypeOverride override) {
        Objects.requireNonNull(override);
        SOUND_TYPE_OVERRIDES.add(override);
    }

    public static void register(SoundTypeOverride ... overrides) {
        for (SoundTypeOverride override : overrides) {
            EnderscapeSoundTypeOverrides.register(override);
        }
    }

    private static String getNameOf(BlockState state) {
        return BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath();
    }

    static {
        Map<SoundType, Predicate<BlockState>> overrides = Map.of(EnderscapeSoundTypes.CHORUS_PLANT, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateChorus && EnderscapeSoundTypeOverrides.getNameOf(state).equals("chorus_plant"), EnderscapeSoundTypes.CHORUS_FLOWER, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateChorus && EnderscapeSoundTypeOverrides.getNameOf(state).equals("chorus_flower"), EnderscapeSoundTypes.PURPUR, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdatePurpur && EnderscapeSoundTypeOverrides.getNameOf(state).contains("purpur"), EnderscapeSoundTypes.END_PORTAL_FRAME, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortalFrame && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_portal_frame"), EnderscapeSoundTypes.END_PORTAL, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_portal"), EnderscapeSoundTypes.END_GATEWAY, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_gateway"), EnderscapeSoundTypes.END_ROD, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndRods && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_rod"), EnderscapeSoundTypes.END_STONE, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStone && EnderscapeSoundTypeOverrides.getNameOf(state).contains("end_stone") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("brick") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("chiseled") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("veiled"), EnderscapeSoundTypes.END_STONE_BRICKS, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStoneBricks && EnderscapeSoundTypeOverrides.getNameOf(state).contains("end_stone") && (EnderscapeSoundTypeOverrides.getNameOf(state).contains("brick") || EnderscapeSoundTypeOverrides.getNameOf(state).contains("chiseled")), EnderscapeSoundTypes.SHULKER_BOX, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateShulkerBoxes && state.getBlock() instanceof ShulkerBoxBlock);
        overrides.forEach((sound, condition) -> EnderscapeSoundTypeOverrides.register(new SoundTypeOverride((SoundType)sound, (Predicate<BlockState>)condition)));
    }
}

