/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.HashMap;
import java.util.Map;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeStats {
    private static final Map<ResourceLocation, StatFormatter> FORMATTERS = new HashMap<ResourceLocation, StatFormatter>();
    public static final ResourceLocation DRIFTER_BOUNCE = EnderscapeStats.register("drifter_bounce", StatFormatter.DEFAULT);
    public static final ResourceLocation ITEMS_ATTRACTED = EnderscapeStats.register("items_attracted", StatFormatter.DEFAULT);
    public static final ResourceLocation MIRROR_TELEPORT = EnderscapeStats.register("mirror_teleport", StatFormatter.DEFAULT);
    public static final ResourceLocation MIRROR_ONE_CM = EnderscapeStats.register("mirror_one_cm", StatFormatter.DISTANCE);
    public static final ResourceLocation RUBBLE_SHIELD_DASH_ONE_CM = EnderscapeStats.register("rubble_shield_dash_one_cm", StatFormatter.DISTANCE);

    private static ResourceLocation register(String name, StatFormatter formatter) {
        ResourceLocation id = Enderscape.id(name);
        RegistryHelper.register(BuiltInRegistries.CUSTOM_STAT, id, () -> id);
        FORMATTERS.put(id, formatter);
        return id;
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (Map.Entry<ResourceLocation, StatFormatter> entry : FORMATTERS.entrySet()) {
                Stats.CUSTOM.get((Object)entry.getKey(), entry.getValue());
            }
        });
    }
}

