/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.GAME)
public class EnderscapeStructureMusic {
    private static final Map<ServerPlayer, Integer> playerTimers = new HashMap<ServerPlayer, Integer>();
    private static final Map<ServerPlayer, ResourceLocation> playerStructures = new HashMap<ServerPlayer, ResourceLocation>();
    private static int structureChangeTimer = 0;

    private static void tryStructureChange(ServerPlayer player, ResourceLocation structure) {
        ResourceLocation currentStructure = playerStructures.get(player);
        if (currentStructure == null || !currentStructure.equals((Object)structure)) {
            playerStructures.put(player, structure);
            playerTimers.put(player, 1200);
        }
    }

    private static ResourceLocation getStructure(ServerLevel level, ServerPlayer player) {
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        List structures = registry.listElements().toList();
        for (Holder.Reference structure : structures) {
            if (structure == null || !level.structureManager().getStructureAt(BlockPos.containing((Position)player.position()), (Structure)structure.value()).isValid()) continue;
            return structure.key().location();
        }
        return ResourceLocation.withDefaultNamespace((String)"none");
    }

    @SubscribeEvent
    public static void onServerUnload(ServerStoppedEvent event) {
        playerStructures.clear();
        playerTimers.clear();
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            playerStructures.remove(player);
            playerTimers.remove(player);
        }
    }

    @SubscribeEvent
    public static void onLevelTickStart(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!playerTimers.isEmpty()) {
            Iterator<Map.Entry<ServerPlayer, Integer>> iterator = playerTimers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ServerPlayer, Integer> entry = iterator.next();
                int newTimer = entry.getValue() - 1;
                if (newTimer <= 0) {
                    ServerPlayer player = entry.getKey();
                    if (playerStructures.containsKey(player)) {
                        player.connection.send((CustomPacketPayload)new ClientboundStructureChangedPayload(playerStructures.get(player)));
                    }
                    iterator.remove();
                    continue;
                }
                entry.setValue(newTimer);
            }
        }
        if (structureChangeTimer-- <= 0) {
            for (ServerPlayer player : level2.getPlayers(LivingEntity::isAlive)) {
                EnderscapeStructureMusic.tryStructureChange(player, EnderscapeStructureMusic.getStructure(level2, player));
            }
            structureChangeTimer = 240;
        }
    }
}

