/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class EnderscapeTrimMaterials {
    public static final HashMap<ResourceKey<TrimMaterial>, Float> TRIM_MATERIALS = new LinkedHashMap<ResourceKey<TrimMaterial>, Float>();
    public static final float NEBULITE_VALUE = 0.632f;
    public static final float SHADOLINE_VALUE = 0.743f;
    public static final ResourceKey<TrimMaterial> NEBULITE = EnderscapeTrimMaterials.register("nebulite", 0.632f);
    public static final ResourceKey<TrimMaterial> SHADOLINE = EnderscapeTrimMaterials.register("shadoline", 0.743f);

    public void bootstrap(BootstrapContext<TrimMaterial> context) {
        EnderscapeTrimMaterials.register(context, NEBULITE, EnderscapeItems.NEBULITE.get(), Style.EMPTY.withColor(0xFF66FF), 0.632f);
        EnderscapeTrimMaterials.register(context, SHADOLINE, EnderscapeItems.SHADOLINE_INGOT.get(), Style.EMPTY.withColor(3234637), 0.743f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> key, Item item, Style style, float f) {
        ResourceLocation location = key.location();
        TrimMaterial material = TrimMaterial.create((String)(location.getNamespace() + "_" + location.getPath()), (Item)item, (float)f, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)location)).withStyle(style), Map.of());
        context.register(key, (Object)material);
    }

    private static ResourceKey<TrimMaterial> register(String name, float value) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)Enderscape.id(name));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)key, Float.valueOf(value));
        return key;
    }
}

