/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimPattern;

public class EnderscapeTrimPatterns {
    public static final List<ResourceKey<TrimPattern>> TRIM_PATTERNS = new ArrayList<ResourceKey<TrimPattern>>();
    public static final ResourceKey<TrimPattern> STASIS = EnderscapeTrimPatterns.register("stasis");

    public void bootstrap(BootstrapContext<TrimPattern> context) {
        EnderscapeTrimPatterns.register(context, EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE.get(), STASIS);
    }

    public static void register(BootstrapContext<TrimPattern> bootstrapContext, Item item, ResourceKey<TrimPattern> key) {
        TrimPattern pattern = new TrimPattern(key.location(), BuiltInRegistries.ITEM.wrapAsHolder((Object)item), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)key.location())), false);
        bootstrapContext.register(key, (Object)pattern);
    }

    private static ResourceKey<TrimPattern> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)Enderscape.id(name));
        TRIM_PATTERNS.add((ResourceKey<TrimPattern>)key);
        return key;
    }
}

