/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="enderscape")
public final class RegistryHelper {
    private static final Map<Pair<String, ResourceKey<? extends Registry<?>>>, DeferredRegister<?>> REGISTERS = new ConcurrentHashMap();
    private static IEventBus MOD_BUS;
    private static boolean ARE_ALL_READY;

    private static <V> DeferredRegister<V> getRegister(Registry<V> registry, ResourceLocation key) {
        Pair registerKey = new Pair((Object)key.getNamespace(), (Object)registry.key());
        return REGISTERS.computeIfAbsent(registerKey, RegistryHelper::makeRegister);
    }

    private static synchronized <T> DeferredRegister<T> makeRegister(Pair<String, ResourceKey<? extends Registry<?>>> key) {
        DeferredRegister register = DeferredRegister.create((ResourceKey)((ResourceKey)key.getSecond()), (String)((String)key.getFirst()));
        if (MOD_BUS != null) {
            register.register(MOD_BUS);
        }
        return register;
    }

    public static <V, T extends V> Supplier<T> register(Registry<V> registry, ResourceKey<V> key, Supplier<T> value) {
        return RegistryHelper.getRegister(registry, key.location()).register(key.location().getPath(), value);
    }

    public static <V, T extends V> Supplier<T> register(Registry<V> registry, ResourceLocation location, Supplier<T> value) {
        return RegistryHelper.getRegister(registry, location).register(location.getPath(), value);
    }

    public static <V, T extends V> DeferredHolder<V, T> registerForHolder(Registry<V> registry, ResourceKey<V> key, Supplier<T> value) {
        return RegistryHelper.getRegister(registry, key.location()).register(key.location().getPath(), value);
    }

    public static <V, T extends V> DeferredHolder<V, T> registerForHolder(Registry<V> registry, ResourceLocation location, Supplier<T> value) {
        return RegistryHelper.getRegister(registry, location).register(location.getPath(), value);
    }

    public RegistryHelper(IEventBus modBus) {
        RegistryHelper.setup(modBus);
        HashSet keys = new HashSet();
        modBus.addListener(RegisterEvent.class, event -> {
            keys.add(event.getRegistry().key());
            if (keys.size() >= BuiltInRegistries.REGISTRY.keySet().size()) {
                ARE_ALL_READY = true;
            }
        });
    }

    private static synchronized void setup(IEventBus modBus) {
        REGISTERS.values().forEach(r -> r.register(modBus));
        MOD_BUS = modBus;
    }

    public static void checkAllReady() {
        if (!ARE_ALL_READY) {
            throw new IllegalStateException("Initialization before registry events are fired. Something is initializing registry-sensitive code too early.");
        }
    }

    static {
        ARE_ALL_READY = false;
    }
}

