/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockUtil
extends net.minecraft.BlockUtil {
    public static boolean place(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!BlockUtil.isInvulnerable(level.getBlockState(pos), (BlockGetter)level, pos)) {
            return level.setBlock(pos, state, 2);
        }
        return false;
    }

    public static boolean replace(LevelAccessor level, BlockPos pos, BlockState state) {
        if (BlockUtil.canReplace(level.getBlockState(pos), (BlockGetter)level, pos)) {
            return level.setBlock(pos, state, 2);
        }
        return false;
    }

    public static boolean canReplace(BlockState state, BlockGetter level, BlockPos pos) {
        return !BlockUtil.isInvulnerable(state, level, pos) && state.canBeReplaced();
    }

    public static boolean isInvulnerable(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getDestroySpeed(level, pos) < 0.0f;
    }

    public static VoxelShape createRotatedShape(double x, double y, double z, double x2, double y2, double z2, Direction direction) {
        double e = 16.0 - y2;
        return switch (direction) {
            case Direction.WEST -> Block.box((double)(y + e), (double)x, (double)z, (double)(y2 + e), (double)x2, (double)z2);
            case Direction.EAST -> Block.box((double)y, (double)z, (double)x, (double)y2, (double)z2, (double)x2);
            case Direction.NORTH -> Block.box((double)x, (double)z, (double)(y + e), (double)x2, (double)z2, (double)(y2 + e));
            case Direction.SOUTH -> Block.box((double)x, (double)z, (double)y, (double)x2, (double)z2, (double)y2);
            case Direction.DOWN -> Block.box((double)x, (double)(y + e), (double)z, (double)x2, (double)(y2 + e), (double)z2);
            default -> Block.box((double)x, (double)y, (double)z, (double)x2, (double)y2, (double)z2);
        };
    }

    public static BlockPos random(BlockPos pos, RandomSource random, int x, int y, int z) {
        return pos.offset(Mth.randomBetweenInclusive((RandomSource)random, (int)(-x), (int)x), Mth.randomBetweenInclusive((RandomSource)random, (int)(-y), (int)y), Mth.randomBetweenInclusive((RandomSource)random, (int)(-z), (int)z));
    }

    public static boolean hasTerrainDepth(LevelAccessor level, BlockPos origin, int depth, Direction direction) {
        BlockPos.MutableBlockPos mutable = origin.mutable();
        while (depth > 0) {
            --depth;
            mutable.move(direction);
            if (level.getBlockState((BlockPos)mutable).isSolidRender((BlockGetter)level, (BlockPos)mutable)) continue;
            return false;
        }
        return depth == 0;
    }

    public static boolean isBlockObstructed(Level level, BlockPos pos) {
        int i = 0;
        for (Direction dir : Direction.values()) {
            BlockPos pos2 = pos.relative(dir);
            if (!level.getBlockState(pos2).canOcclude() || ++i != 6) continue;
            return true;
        }
        return false;
    }
}

