/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.util;

import java.awt.Color;
import java.util.function.Function;
import net.bunten.enderscape.biome.util.SkyParameters;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public record RGBA(int color, float alpha) {
    public static final double[] GAUSSIAN_SAMPLE_KERNEL = RGBA.generateGaussianKernel(2);

    public static int darkenColor(int color, float factor) {
        Color original = new Color(color);
        int r = (int)((float)original.getRed() * factor);
        int g = (int)((float)original.getGreen() * factor);
        int b = (int)((float)original.getBlue() * factor);
        return r << 16 | g << 8 | b;
    }

    public static float sampleFloat(BiomeManager manager, Vec3 pos, Function<SkyParameters, Float> provided, float defaults) {
        return RGBA.sampleFloat(pos, (x, y, z) -> SkyParameters.getSkyParametersFor((Holder<Biome>)manager.getNoiseBiomeAtQuart(x, y, z)).map(provided).orElse(Float.valueOf(defaults)).floatValue());
    }

    public static Vector4f sampleVector4f(BiomeManager manager, Vec3 pos, Function<SkyParameters, RGBA> provided, RGBA defaults) {
        return RGBA.sampleVector4f(pos, (x, y, z) -> {
            RGBA rgba = SkyParameters.getSkyParametersFor((Holder<Biome>)manager.getNoiseBiomeAtQuart(x, y, z)).map(provided).orElse(defaults);
            Vec3 color = Vec3.fromRGB24((int)rgba.color());
            return new Vector4f((float)color.x, (float)color.y, (float)color.z, rgba.alpha());
        });
    }

    public static double[] generateGaussianKernel(int radius) {
        int i;
        int size = radius * 2 + 1;
        double[] kernel = new double[size];
        double sigma = (double)radius / 2.0;
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double x = i - radius;
            kernel[i] = Math.exp(-0.5 * (x * x) / (sigma * sigma));
            sum += kernel[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    public static float sampleFloat(Vec3 vec3, FloatFetcher fetcher) {
        int i = Mth.floor((double)vec3.x());
        int j = Mth.floor((double)vec3.y());
        int k = Mth.floor((double)vec3.z());
        double d = vec3.x() - (double)i;
        double e = vec3.y() - (double)j;
        double f = vec3.z() - (double)k;
        double g = 0.0;
        float result = 0.0f;
        int kernelSize = GAUSSIAN_SAMPLE_KERNEL.length;
        int radius = kernelSize / 2;
        for (int l = 0; l < kernelSize - 1; ++l) {
            double h = Mth.lerp((double)d, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int m = i - radius + l;
            for (int n = 0; n < kernelSize - 1; ++n) {
                double o = Mth.lerp((double)e, (double)GAUSSIAN_SAMPLE_KERNEL[n + 1], (double)GAUSSIAN_SAMPLE_KERNEL[n]);
                int p = j - radius + n;
                for (int q = 0; q < kernelSize - 1; ++q) {
                    double r = Mth.lerp((double)f, (double)GAUSSIAN_SAMPLE_KERNEL[q + 1], (double)GAUSSIAN_SAMPLE_KERNEL[q]);
                    int s = k - radius + q;
                    double t = h * o * r;
                    g += t;
                    result += fetcher.fetch(m, p, s) * (float)t;
                }
            }
        }
        return result *= 1.0f / (float)g;
    }

    public static Vector4f sampleVector4f(Vec3 vec3, Vec4Fetcher fetcher) {
        int i = Mth.floor((double)vec3.x());
        int j = Mth.floor((double)vec3.y());
        int k = Mth.floor((double)vec3.z());
        double d = vec3.x() - (double)i;
        double e = vec3.y() - (double)j;
        double f = vec3.z() - (double)k;
        double g = 0.0;
        Vector4f result = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        int kernelSize = GAUSSIAN_SAMPLE_KERNEL.length;
        int radius = kernelSize / 2;
        for (int l = 0; l < kernelSize - 1; ++l) {
            double h = Mth.lerp((double)d, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int m = i - radius + l;
            for (int n = 0; n < kernelSize - 1; ++n) {
                double o = Mth.lerp((double)e, (double)GAUSSIAN_SAMPLE_KERNEL[n + 1], (double)GAUSSIAN_SAMPLE_KERNEL[n]);
                int p = j - radius + n;
                for (int q = 0; q < kernelSize - 1; ++q) {
                    double r = Mth.lerp((double)f, (double)GAUSSIAN_SAMPLE_KERNEL[q + 1], (double)GAUSSIAN_SAMPLE_KERNEL[q]);
                    int s = k - radius + q;
                    double t = h * o * r;
                    g += t;
                    result.add((Vector4fc)fetcher.fetch(m, p, s).mul((float)t));
                }
            }
        }
        result.mul(1.0f / (float)g);
        return result;
    }

    @FunctionalInterface
    public static interface FloatFetcher {
        public float fetch(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface Vec4Fetcher {
        public Vector4f fetch(int var1, int var2, int var3);
    }
}

