/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unascribed.ears.NotRandom119;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.EarsFeaturesHolder;
import com.unascribed.ears.common.EarsFeaturesStorage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.render.IndirectEarsRenderDelegate;
import com.unascribed.ears.common.util.Decider;
import com.unascribed.ears.mixin.AccessorHumanoidArmorLayer;
import com.unascribed.ears.mixin.AccessorLivingEntityRenderer;
import com.unascribed.ears.mixin.AccessorPlayerModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class EarsLayerRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final PlayerRenderer per;
    private final IndirectEarsRenderDelegate<PoseStack, MultiBufferSource, VertexConsumer, AbstractClientPlayer, ModelPart> delegate = new IndirectEarsRenderDelegate<PoseStack, MultiBufferSource, VertexConsumer, AbstractClientPlayer, ModelPart>(){
        private float armorR = 1.0f;
        private float armorG = 1.0f;
        private float armorB = 1.0f;
        private float armorA = 1.0f;
        private HumanoidArmorLayer<?, ?, ?> afr;
        private final ModelPart blank = new ModelPart(Collections.emptyList(), Collections.emptyMap());
        private final ModelPart dummyRoot = new ModelPart(Collections.emptyList(), (Map)ImmutableMap.builder().put((Object)"head", (Object)this.blank).put((Object)"hat", (Object)this.blank).put((Object)"body", (Object)this.blank).put((Object)"left_arm", (Object)this.blank).put((Object)"right_arm", (Object)this.blank).put((Object)"left_leg", (Object)this.blank).put((Object)"right_leg", (Object)this.blank).build());
        private final HumanoidModel<?> dummyModel = new HumanoidModel<Player>(this.dummyRoot){

            public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
                vc = vertices;
            }
        };

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ModelPart> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ModelPart> d) {
            PlayerModel model = (PlayerModel)EarsLayerRenderer.this.getParentModel();
            return d.map(EarsRenderDelegate.BodyPart.HEAD, model.head).map(EarsRenderDelegate.BodyPart.LEFT_ARM, model.leftArm).map(EarsRenderDelegate.BodyPart.LEFT_LEG, model.leftLeg).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, model.rightArm).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, model.rightLeg).map(EarsRenderDelegate.BodyPart.TORSO, model.body);
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ModelPart modelPart) {
            modelPart.translateAndRotate((PoseStack)this.matrices);
            ModelPart.Cube cuboid = modelPart.getRandomCube((RandomSource)NotRandom119.INSTANCE);
            ((PoseStack)this.matrices).scale(0.0625f, 0.0625f, 0.0625f);
            ((PoseStack)this.matrices).translate(cuboid.minX, cuboid.maxY, cuboid.minZ);
        }

        @Override
        protected boolean isVisible(ModelPart modelPart) {
            return modelPart.visible;
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            return EarsLayerRenderer.getEarsFeatures((AbstractClientPlayer)this.peer);
        }

        @Override
        public boolean isSlim() {
            return ((AccessorPlayerModel)EarsLayerRenderer.this.getParentModel()).ears$isSlim();
        }

        @Override
        protected void pushMatrix() {
            ((PoseStack)this.matrices).pushPose();
        }

        @Override
        protected void popMatrix() {
            ((PoseStack)this.matrices).popPose();
        }

        @Override
        protected void doTranslate(float x, float y, float z) {
            ((PoseStack)this.matrices).translate(x, y, z);
        }

        @Override
        protected void doRotate(float ang, float x, float y, float z) {
            ((PoseStack)this.matrices).mulPose(new Quaternionf(new AxisAngle4f(ang * ((float)Math.PI / 180), x, y, z)));
        }

        @Override
        protected void doScale(float x, float y, float z) {
            ((PoseStack)this.matrices).scale(x, y, z);
        }

        @Override
        protected void doUploadAux(EarsRenderDelegate.TexSource src, byte[] pngData) {
            ResourceLocation skin = ((AbstractClientPlayer)this.peer).getSkin().texture();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)skin.getNamespace(), (String)src.addSuffix(skin.getPath()));
            if (pngData != null && Minecraft.getInstance().getTextureManager().getTexture(id, null) == null) {
                try {
                    Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)new DynamicTexture(NativeImage.read((ByteBuffer)1.toNativeBuffer(pngData))));
                }
                catch (IOException e) {
                    Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)MissingTextureAtlasSprite.getTexture());
                }
            }
        }

        @Override
        protected void doBindBuiltin(EarsRenderDelegate.TexSource src) {
            this.commitQuads();
            if (src.isGlint()) {
                this.armorA = 1.0f;
                this.armorB = 1.0f;
                this.armorG = 1.0f;
                this.armorR = 1.0f;
                this.vc = ((MultiBufferSource)this.vcp).getBuffer(RenderType.armorEntityGlint());
            } else if (this.canBind(src)) {
                EquipmentSlot slot = this.getSlot(src);
                ItemStack equipment = ((AbstractClientPlayer)this.peer).getItemBySlot(slot);
                ArmorItem ai = (ArmorItem)equipment.getItem();
                ArmorMaterial m = (ArmorMaterial)ai.getMaterial().value();
                AccessorHumanoidArmorLayer aafr = (AccessorHumanoidArmorLayer)this.afr;
                int c = equipment.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)equipment, (int)-6265536) : -1;
                ArmorMaterial.Layer l = (ArmorMaterial.Layer)m.layers().get(0);
                try {
                    aafr.ears$renderArmorParts((PoseStack)this.matrices, (MultiBufferSource)this.vcp, 0, this.dummyModel, c, l.texture(aafr.ears$usesSecondLayer(slot)));
                }
                catch (Throwable t) {
                    if (this.skipRendering == 0) {
                        this.skipRendering = 1;
                    }
                    EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Exception while attempting to retrieve armor texture", t);
                }
            }
        }

        @Override
        public boolean canBind(EarsRenderDelegate.TexSource tex) {
            EquipmentSlot slot;
            boolean glint = tex.isGlint();
            if (glint) {
                tex = tex.getParent();
            }
            if ((slot = this.getSlot(tex)) == null) {
                return super.canBind(tex);
            }
            ItemStack equipment = ((AbstractClientPlayer)this.peer).getItemBySlot(slot);
            if (equipment.isEmpty() || !(equipment.getItem() instanceof ArmorItem)) {
                return false;
            }
            if (this.afr == null) {
                for (RenderLayer<?, ?> fr : ((AccessorLivingEntityRenderer)EarsLayerRenderer.this.per).ears$getLayers()) {
                    if (!(fr instanceof HumanoidArmorLayer)) continue;
                    this.afr = (HumanoidArmorLayer)fr;
                }
            }
            if (this.afr != null) {
                AccessorHumanoidArmorLayer aafr = (AccessorHumanoidArmorLayer)this.afr;
                HumanoidModel<?> bmodel = aafr.ears$getBodyModel();
                HumanoidModel<?> lmodel = aafr.ears$getLeggingsModel();
                HumanoidModel<?> model = aafr.ears$getArmor(slot);
                if (model != bmodel && model != lmodel) {
                    return false;
                }
                return glint ? equipment.hasFoil() : true;
            }
            return false;
        }

        private EquipmentSlot getSlot(EarsRenderDelegate.TexSource tex) {
            return Decider.begin(tex).map(EarsRenderDelegate.TexSource.HELMET, EquipmentSlot.HEAD).map(EarsRenderDelegate.TexSource.CHESTPLATE, EquipmentSlot.CHEST).map(EarsRenderDelegate.TexSource.LEGGINGS, EquipmentSlot.LEGS).map(EarsRenderDelegate.TexSource.BOOTS, EquipmentSlot.FEET).orElse(null);
        }

        @Override
        protected void addVertex(float x, float y, int z, float r, float g, float b, float a, float u, float v, float nX, float nY, float nZ) {
            Matrix4f mm = ((PoseStack)this.matrices).last().pose();
            ((VertexConsumer)this.vc).addVertex(mm, x, y, (float)z).setColor(r *= this.armorR, g *= this.armorG, b *= this.armorB, a *= this.armorA).setUv(u, v).setOverlay(this.overlay).setLight(this.emissive ? LightTexture.pack((int)15, (int)15) : this.light);
            if (this.emissive) {
                ((VertexConsumer)this.vc).setNormal(nX, nY, nZ);
            } else {
                ((VertexConsumer)this.vc).setNormal(((PoseStack)this.matrices).last(), nX, nY, nZ);
            }
        }

        @Override
        protected void commitQuads() {
            if (this.vcp instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)this.vcp).endLastBatch();
            }
        }

        @Override
        protected void doRenderDebugDot(float r, float g, float b, float a) {
        }

        @Override
        protected VertexConsumer getVertexConsumer(EarsRenderDelegate.TexSource src) {
            this.armorA = 1.0f;
            this.armorB = 1.0f;
            this.armorG = 1.0f;
            this.armorR = 1.0f;
            ResourceLocation id = ((AbstractClientPlayer)this.peer).getSkin().texture();
            if (src != EarsRenderDelegate.TexSource.SKIN) {
                id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)src.addSuffix(id.getPath()));
            }
            return ((MultiBufferSource)this.vcp).getBuffer(RenderType.entityTranslucentCull((ResourceLocation)id));
        }

        @Override
        public float getTime() {
            return (float)((AbstractClientPlayer)this.peer).tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        }

        @Override
        public boolean isFlying() {
            return ((AbstractClientPlayer)this.peer).getAbilities().flying;
        }

        @Override
        public boolean isGliding() {
            return ((AbstractClientPlayer)this.peer).isFallFlying();
        }

        @Override
        public boolean isJacketEnabled() {
            return ((AbstractClientPlayer)this.peer).isModelPartShown(PlayerModelPart.JACKET);
        }

        @Override
        public boolean isWearingBoots() {
            return ((AbstractClientPlayer)this.peer).getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ArmorItem;
        }

        @Override
        public boolean isWearingChestplate() {
            return ((AbstractClientPlayer)this.peer).getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem;
        }

        @Override
        public boolean isWearingElytra() {
            return ((AbstractClientPlayer)this.peer).getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ElytraItem;
        }

        @Override
        public float getHorizontalSpeed() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).walkDistO, ((AbstractClientPlayer)this.peer).walkDist, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public float getLimbSwing() {
            return ((AbstractClientPlayer)this.peer).walkAnimation.speed(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public float getStride() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).oBob, ((AbstractClientPlayer)this.peer).bob, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public float getBodyYaw() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).yBodyRotO, ((AbstractClientPlayer)this.peer).yBodyRot, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getCapeX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).xCloakO, ((AbstractClientPlayer)this.peer).xCloak, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getCapeY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).yCloakO, ((AbstractClientPlayer)this.peer).yCloak, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getCapeZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).zCloakO, ((AbstractClientPlayer)this.peer).zCloak, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).xOld, ((AbstractClientPlayer)this.peer).getX(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).yOld, ((AbstractClientPlayer)this.peer).getY(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }

        @Override
        public double getZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).zOld, ((AbstractClientPlayer)this.peer).getZ(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }
    };

    public EarsLayerRenderer(PlayerRenderer per) {
        super((RenderLayerParent)per);
        this.per = per;
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Constructed");
    }

    public void render(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "render({}, {}, {}, {}, {}, {}, {}, {}, {})", m, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
    }

    public void renderLeftArm(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity) {
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), EarsRenderDelegate.BodyPart.LEFT_ARM);
    }

    public void renderRightArm(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity) {
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), EarsRenderDelegate.BodyPart.RIGHT_ARM);
    }

    public static EarsFeatures getEarsFeatures(AbstractClientPlayer peer) {
        ResourceLocation skin = peer.getSkin().texture();
        AbstractTexture tex = Minecraft.getInstance().getTextureManager().getTexture(skin);
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "getEarsFeatures(): skin={}, tex={}", (Object)skin, (Object)tex);
        if (tex instanceof EarsFeaturesHolder) {
            EarsFeatures feat = ((EarsFeaturesHolder)tex).getEarsFeatures();
            EarsFeaturesStorage.INSTANCE.put(peer.getGameProfile().getName(), peer.getGameProfile().getId(), feat);
            if (!peer.isInvisible()) {
                return feat;
            }
        }
        return EarsFeatures.DISABLED;
    }
}

