/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter;

import dev.tazer.mixed_litter.VariantUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="mixed_litter")
public class Events {
    @SubscribeEvent
    public static void onEntitySpawned(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        ServerLevelAccessor levelAccessor = event.getLevel();
        VariantUtil.applySuitableVariants(mob, levelAccessor);
    }

    @SubscribeEvent
    public static void onEntityLoaded(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof Mob) {
                Mob mob = (Mob)level;
                VariantUtil.validateVariants(mob, (ServerLevelAccessor)serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawned(BabyEntitySpawnEvent event) {
        Level level;
        AgeableMob child = event.getChild();
        if (child != null && (level = child.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Mob parentA = event.getParentA();
            Mob parentB = event.getParentB();
            VariantUtil.setChildVariant(parentA, parentB, (Mob)child, (ServerLevelAccessor)serverLevel);
        }
    }

    @SubscribeEvent
    public static void sendVariantsToTrackers(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof Mob) {
                Mob mob = (Mob)player;
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)VariantUtil.getVariantData(mob), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

