/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter;

import com.mojang.serialization.MapCodec;
import dev.tazer.mixed_litter.MLDataAttachmentTypes;
import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.networking.VariantData;
import dev.tazer.mixed_litter.networking.VariantRequestData;
import dev.tazer.mixed_litter.variants.DynamicVariant;
import dev.tazer.mixed_litter.variants.MobVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class VariantUtil {
    public static HolderSet<MobVariant> getVariants(Mob mob, LevelAccessor levelAccessor) {
        ArrayList animalVariantHolderSet = new ArrayList();
        Registry variantRegistry = levelAccessor.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
        if (levelAccessor.isClientSide()) {
            CompoundTag tag = new CompoundTag();
            mob.saveWithoutId(tag);
            if (!mob.hasData(MLDataAttachmentTypes.MOB_VARIANTS)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new VariantRequestData(mob.getId(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        String variantString = "";
        if (mob.hasData(MLDataAttachmentTypes.MOB_VARIANTS)) {
            variantString = (String)mob.getData(MLDataAttachmentTypes.MOB_VARIANTS);
        }
        for (int i = 0; i < ((String)mob.getData(MLDataAttachmentTypes.MOB_VARIANTS)).split(", ").length; ++i) {
            variantRegistry.getHolder(ResourceLocation.parse((String)variantString.split(", ")[i])).map(animalVariantHolderSet::add);
        }
        return HolderSet.direct(animalVariantHolderSet);
    }

    public static VariantData getVariantData(Mob mob) {
        CompoundTag tag = new CompoundTag();
        mob.saveWithoutId(tag);
        String variantString = "";
        if (mob.hasData(MLDataAttachmentTypes.MOB_VARIANTS)) {
            variantString = (String)mob.getData(MLDataAttachmentTypes.MOB_VARIANTS);
        }
        String subVariant = "";
        return new VariantData(mob.getId(), tag, variantString, subVariant);
    }

    public static void setVariants(Mob mob, ServerLevelAccessor levelAccessor, MobVariant ... variants) {
        VariantUtil.setVariants(mob, levelAccessor, Arrays.asList(variants));
    }

    public static void setVariants(Mob mob, ServerLevelAccessor levelAccessor, List<MobVariant> variants) {
        ArrayList variantIds = new ArrayList();
        Registry variantRegistry = levelAccessor.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
        variants.forEach(variant -> Optional.ofNullable(variantRegistry.getKey(variant)).map(ResourceLocation::toString).map(variantIds::add));
        String subVariant = "";
        for (MobVariant variant2 : variants) {
            DynamicVariant dynamic;
            if (variant2 instanceof DynamicVariant && !(subVariant = (dynamic = (DynamicVariant)variant2).fetchTexture((LivingEntity)mob).map(ResourceLocation::toString).orElse("")).isEmpty()) break;
        }
        String variantString = String.join((CharSequence)", ", variantIds);
        mob.setData(MLDataAttachmentTypes.MOB_VARIANTS, (Object)variantString);
        CompoundTag tag = new CompoundTag();
        mob.saveWithoutId(tag);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)mob, (CustomPacketPayload)new VariantData(mob.getId(), tag, variantString, subVariant), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void setChildVariant(Mob parentA, Mob parentB, Mob child, ServerLevelAccessor levelAccessor) {
        Registry variantTypeRegistry = levelAccessor.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
        HashMap groupedVariants = new HashMap();
        variantTypeRegistry.holders().filter(animalVariantReference -> ((MobVariant)animalVariantReference.value()).isFor(child.getType())).forEach(animalVariantReference -> groupedVariants.computeIfAbsent(((MobVariant)animalVariantReference.value()).codec(), mapCodec -> new ArrayList()).add((MobVariant)animalVariantReference.value()));
        ArrayList<MobVariant> AVariants = new ArrayList<MobVariant>();
        ArrayList<MobVariant> BVariants = new ArrayList<MobVariant>();
        for (Holder animalVariantHolder : VariantUtil.getVariants(parentA, (LevelAccessor)levelAccessor).stream().toList()) {
            AVariants.add((MobVariant)animalVariantHolder.value());
        }
        for (Holder animalVariantHolder : VariantUtil.getVariants(parentB, (LevelAccessor)levelAccessor).stream().toList()) {
            BVariants.add((MobVariant)animalVariantHolder.value());
        }
        ArrayList<MobVariant> childVariants = new ArrayList<MobVariant>();
        for (List possibleVariants : groupedVariants.values()) {
            ArrayList<MobVariant> availableVariants = new ArrayList<MobVariant>();
            for (MobVariant variant : possibleVariants) {
                if (!AVariants.contains(variant) && !BVariants.contains(variant)) continue;
                availableVariants.add(variant);
            }
            if (availableVariants.isEmpty()) continue;
            MobVariant chosenVariant = (MobVariant)availableVariants.get(child.getRandom().nextInt(availableVariants.size()));
            childVariants.add(chosenVariant);
        }
        VariantUtil.setVariants(child, levelAccessor, childVariants);
    }

    public static void applySuitableVariants(Mob mob, ServerLevelAccessor levelAccessor) {
        Registry variantTypeRegistry = levelAccessor.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
        HashMap groupedAnimals = new HashMap();
        variantTypeRegistry.holders().filter(animalVariantReference -> ((MobVariant)animalVariantReference.value()).isFor(mob.getType())).forEach(animalVariantReference -> groupedAnimals.computeIfAbsent(((MobVariant)animalVariantReference.value()).codec(), mapCodec -> new ArrayList()).add((MobVariant)animalVariantReference.value()));
        if (!groupedAnimals.isEmpty()) {
            ArrayList<MobVariant> selectedVariants = new ArrayList<MobVariant>();
            for (List variants : groupedAnimals.values()) {
                selectedVariants.add(((MobVariant)variants.getFirst()).select((LivingEntity)mob, (LevelAccessor)levelAccessor, variants));
            }
            VariantUtil.setVariants(mob, levelAccessor, selectedVariants);
        }
    }

    public static void validateVariants(Mob mob, ServerLevelAccessor levelAccessor) {
        Registry variantRegistry = levelAccessor.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
        HashMap groupedVariants = new HashMap();
        variantRegistry.holders().filter(ref -> ((MobVariant)ref.value()).isFor(mob.getType())).forEach(ref -> groupedVariants.computeIfAbsent(((MobVariant)ref.value()).codec(), codec -> new ArrayList()).add((MobVariant)ref.value()));
        ArrayList<MobVariant> currentVariants = new ArrayList<MobVariant>();
        for (Holder animalVariantHolder : VariantUtil.getVariants(mob, (LevelAccessor)levelAccessor)) {
            currentVariants.add((MobVariant)animalVariantHolder.value());
        }
        List<MobVariant> updatedVariants = currentVariants.stream().filter(variant -> {
            MapCodec<? extends MobVariant> codec = variant.codec();
            List validVariants = (List)groupedVariants.get(codec);
            return validVariants != null && validVariants.contains(variant);
        }).collect(Collectors.toList());
        for (Map.Entry entry : groupedVariants.entrySet()) {
            MapCodec codec = (MapCodec)entry.getKey();
            boolean alreadyPresent = updatedVariants.stream().anyMatch(variant -> variant.codec().equals((Object)codec));
            if (alreadyPresent) continue;
            MobVariant newVariant = ((MobVariant)((List)entry.getValue()).getFirst()).select((LivingEntity)mob, (LevelAccessor)levelAccessor, (List)entry.getValue());
            updatedVariants.add(newVariant);
        }
        VariantUtil.setVariants(mob, levelAccessor, updatedVariants);
    }
}

