/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin;

import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.MobVariant;
import dev.tazer.mixed_litter.variants.remodels.CowVariant;
import dev.tazer.mixed_litter.variants.remodels.MooshroomVariant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.EventHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MushroomCow.class})
public abstract class MushroomCowMixin {
    @Shadow
    @Nullable
    private UUID lastLightningBoltUUID;
    MushroomCow self = (MushroomCow)this;

    @Inject(method={"thunderHit"}, at={@At(value="HEAD")}, cancellable=true)
    private void thunderRandomisesVariant(ServerLevel level, LightningBolt lightning, CallbackInfo ci) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            Registry variantTypeRegistry = this.self.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
            HashMap groupedAnimals = new HashMap();
            variantTypeRegistry.holders().filter(animalVariantReference -> ((MobVariant)animalVariantReference.value()).isFor(this.self.getType())).forEach(animalVariantReference -> groupedAnimals.computeIfAbsent(((MobVariant)animalVariantReference.value()).codec(), mapCodec -> new ArrayList()).add((MobVariant)animalVariantReference.value()));
            ArrayList<MobVariant> selectedVariants = new ArrayList<MobVariant>();
            for (List variants : groupedAnimals.values()) {
                selectedVariants.add((MobVariant)variants.get(this.self.getRandom().nextInt(variants.size())));
            }
            VariantUtil.setVariants((Mob)this, (ServerLevelAccessor)level, selectedVariants);
        }
        ci.cancel();
    }

    @Inject(method={"shear"}, at={@At(value="HEAD")}, cancellable=true)
    private void biodiversity$shear(SoundSource category, CallbackInfo ci) {
        Level level = this.self.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MooshroomVariant variant = null;
            for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)this, (LevelAccessor)serverLevel)) {
                MooshroomVariant mooshroomVariant;
                Object object = animalVariantHolder.value();
                if (!(object instanceof MooshroomVariant)) continue;
                variant = mooshroomVariant = (MooshroomVariant)object;
                break;
            }
            if (variant != null) {
                this.self.level().playSound(null, (Entity)((LivingEntity)this), SoundEvents.MOOSHROOM_SHEAR, category, 1.0f, 1.0f);
                if (!EventHooks.canLivingConvert((LivingEntity)((LivingEntity)this), (EntityType)EntityType.COW, timer -> {})) {
                    return;
                }
                Cow cow = (Cow)EntityType.COW.create(this.self.level());
                if (cow != null) {
                    EventHooks.onLivingConvert((LivingEntity)((LivingEntity)this), (LivingEntity)cow);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.self.getX(), this.self.getY(0.5), this.self.getZ(), 2, 0.0, 0.0, 0.0, 0.1);
                    this.self.discard();
                    cow.moveTo(this.self.getX(), this.self.getY(), this.self.getZ(), this.self.getYRot(), this.self.getXRot());
                    cow.setHealth(this.self.getHealth());
                    cow.yBodyRot = this.self.yBodyRot;
                    cow.setInvulnerable(this.self.isInvulnerable());
                    if (this.self.isPersistenceRequired()) {
                        cow.setPersistenceRequired();
                    }
                    if (this.self.hasCustomName()) {
                        cow.setCustomName(this.self.getCustomName());
                        cow.setCustomNameVisible(this.self.isCustomNameVisible());
                    }
                    HashMap groupedAnimals = new HashMap();
                    VariantUtil.getVariants((Mob)cow, (LevelAccessor)serverLevel).forEach(animalVariantReference -> groupedAnimals.computeIfAbsent(((MobVariant)animalVariantReference.value()).codec(), mapCodec -> new ArrayList()).add((MobVariant)animalVariantReference.value()));
                    Registry variantRegistry = this.self.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY);
                    ArrayList<MobVariant> selectedVariants = new ArrayList<MobVariant>();
                    for (List variants : groupedAnimals.values()) {
                        if (variants.stream().findAny().orElseThrow() instanceof CowVariant) {
                            selectedVariants.add((MobVariant)variantRegistry.get(variant.cowVariant));
                            continue;
                        }
                        selectedVariants.add((MobVariant)variants.stream().findAny().orElseThrow());
                    }
                    VariantUtil.setVariants((Mob)this, (ServerLevelAccessor)serverLevel, selectedVariants);
                    this.self.level().addFreshEntity((Entity)cow);
                    if (variant.mushroom != Blocks.AIR) {
                        for (int i = 0; i < this.self.getRandom().nextInt(3, 7); ++i) {
                            ItemEntity item = this.self.spawnAtLocation(new ItemStack((ItemLike)variant.mushroom), this.self.getBbHeight());
                            if (item == null) continue;
                            item.setNoPickUpDelay();
                        }
                    }
                }
                ci.cancel();
            }
        }
    }
}

