/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=999)
public class RenderEntityVariantMixin<T extends LivingEntity> {
    @Unique
    private static Mob STORED_ENTITY = null;

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")})
    public void storeRenderTypeVariables(T entity, boolean p_115323_, boolean p_115324_, boolean p_115325_, CallbackInfoReturnable<RenderType> cir) {
        if (entity instanceof Mob) {
            Mob mob;
            STORED_ENTITY = mob = (Mob)entity;
        }
    }

    @ModifyVariable(method={"getRenderType"}, at=@At(value="STORE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;getTextureLocation(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/resources/ResourceLocation;"))
    public ResourceLocation getVariantTexture(ResourceLocation value) {
        if (STORED_ENTITY != null) {
            Mob entity = STORED_ENTITY;
            String subVariant = "";
            if (subVariant.contains(":")) {
                ResourceLocation location = ResourceLocation.tryParse((String)subVariant);
                if (location == null) {
                    return value;
                }
                location = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/" + location.getPath() + ".png"));
                return location;
            }
        }
        return value;
    }
}

