/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.mixin.layers.RenderLayerMixin;
import dev.tazer.mixed_litter.variants.remodels.PigVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SaddleLayer.class})
public abstract class SaddleLayerMixin<T extends Entity, M extends EntityModel<T>>
extends RenderLayerMixin<T, M> {
    @Shadow
    @Final
    private M model;
    @Shadow
    @Final
    private ResourceLocation textureLocation;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void mixedLitter$render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (((Saddleable)livingEntity).isSaddled()) {
            this.getParentModel().copyPropertiesTo(this.model);
            this.model.prepareMobModel(livingEntity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            poseStack.pushPose();
            poseStack.scale(1.05f, 1.0f, 1.05f);
            poseStack.translate(0.0f, -0.025f, 0.0f);
            ResourceLocation saddleTexture = this.textureLocation;
            if (((Boolean)MLConfig.PIG.get()).booleanValue() && livingEntity.getType() == EntityType.PIG && livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                PigVariant variant = null;
                for (Holder mobVariantHolder : VariantUtil.getVariants(mob, (LevelAccessor)livingEntity.level())) {
                    PigVariant pigVariant;
                    Object object = mobVariantHolder.value();
                    if (!(object instanceof PigVariant)) continue;
                    variant = pigVariant = (PigVariant)object;
                    break;
                }
                if (variant != null) {
                    saddleTexture = variant.saddleTexture.withPath(path -> "textures/" + path + ".png");
                }
            }
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)saddleTexture));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        ci.cancel();
    }
}

