/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.mixin.layers.RenderLayerMixin;
import dev.tazer.mixed_litter.variants.remodels.SheepVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.SheepFurLayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SheepFurLayer.class})
public abstract class SheepFurLayerMixin
extends RenderLayerMixin<Sheep, SheepModel<Sheep>> {
    @Unique
    private SheepModel<Sheep> mixedLitter$model;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(RenderLayerParent<Sheep, SheepModel<Sheep>> renderer, EntityModelSet modelSet, CallbackInfo ci) {
        this.mixedLitter$model = new SheepModel(modelSet.bakeLayer(ModelLayers.SHEEP));
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/animal/Sheep;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mixedLitter$render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Sheep sheep, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (((Boolean)MLConfig.SHEEP.get()).booleanValue()) {
            SheepVariant variant = null;
            for (Holder mobVariantHolder : VariantUtil.getVariants((Mob)sheep, (LevelAccessor)sheep.level())) {
                SheepVariant sheepVariant;
                Object object = mobVariantHolder.value();
                if (!(object instanceof SheepVariant)) continue;
                variant = sheepVariant = (SheepVariant)object;
                break;
            }
            if (variant != null) {
                ResourceLocation furTexture = (sheep.isBaby() ? variant.babyFurTexture : (sheep.isSheared() ? variant.shearedFurTexture : variant.furTexture)).withPath(path -> "textures/" + path + ".png");
                if (sheep.isInvisible()) {
                    Minecraft minecraft = Minecraft.getInstance();
                    if (minecraft.shouldEntityAppearGlowing((Entity)sheep)) {
                        ((SheepModel)this.getParentModel()).copyPropertiesTo(this.mixedLitter$model);
                        this.mixedLitter$model.prepareMobModel(sheep, limbSwing, limbSwingAmount, partialTicks);
                        this.mixedLitter$model.setupAnim(sheep, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.outline((ResourceLocation)furTexture));
                        this.mixedLitter$model.renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)sheep, (float)0.0f), -16777216);
                    }
                } else {
                    int i;
                    if (sheep.hasCustomName() && sheep.getName().getString().equals("jeb_")) {
                        int k = sheep.tickCount / 25 + sheep.getId();
                        int l = DyeColor.values().length;
                        int i1 = k % l;
                        int j1 = (k + 1) % l;
                        float f = ((float)(sheep.tickCount % 25) + partialTicks) / 25.0f;
                        int k1 = Sheep.getColor((DyeColor)DyeColor.byId((int)i1));
                        int l1 = Sheep.getColor((DyeColor)DyeColor.byId((int)j1));
                        i = FastColor.ARGB32.lerp((float)f, (int)k1, (int)l1);
                    } else {
                        i = Sheep.getColor((DyeColor)sheep.getColor());
                    }
                    SheepFurLayerMixin.mixedLitter$coloredCutoutModelCopyLayerRender(this.getParentModel(), this.mixedLitter$model, furTexture, poseStack, buffer, packedLight, sheep, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks, i);
                }
                ci.cancel();
            }
        }
    }

    @Unique
    private static <T extends LivingEntity> void mixedLitter$coloredCutoutModelCopyLayerRender(EntityModel<T> modelParent, EntityModel<T> model, ResourceLocation textureLocation, PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick, int color) {
        if (!entity.isInvisible()) {
            modelParent.copyPropertiesTo(model);
            model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
            model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            SheepFurLayerMixin.mixedLitter$renderColoredCutoutModel(model, textureLocation, poseStack, buffer, packedLight, entity, color);
        }
    }

    @Unique
    private static <T extends LivingEntity> void mixedLitter$renderColoredCutoutModel(EntityModel<T> model, ResourceLocation textureLocation, PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, int color) {
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)textureLocation));
        model.renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), color);
    }
}

