/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.models;

import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.mixin.models.QuadrupedModelMixin;
import dev.tazer.mixed_litter.models.SheepRemodel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.world.entity.animal.Sheep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SheepModel.class})
public class SheepModelMixin<T extends Sheep>
extends QuadrupedModelMixin<T> {
    @Unique
    private float mixedLitter$headXRot;

    @Inject(method={"createBodyLayer"}, at={@At(value="RETURN")}, cancellable=true)
    private static void mixedLitter$createBodyLayer(CallbackInfoReturnable<LayerDefinition> cir) {
        if (((Boolean)MLConfig.SHEEP.get()).booleanValue()) {
            cir.setReturnValue((Object)SheepRemodel.createBodyLayer());
        }
    }

    @Override
    public void mixedLitter$setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (((Boolean)MLConfig.SHEEP.get()).booleanValue()) {
            SheepRemodel.setupAnim(entity, this.mixedLitter$root, ageInTicks, this.mixedLitter$headXRot);
        }
    }

    @Inject(method={"prepareMobModel(Lnet/minecraft/world/entity/animal/Sheep;FFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mixedLitter$prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick, CallbackInfo ci) {
        if (((Boolean)MLConfig.SHEEP.get()).booleanValue()) {
            this.head.y = 11.0f + entity.getHeadEatPositionScale(partialTick) * 7.0f;
            this.mixedLitter$headXRot = entity.getHeadEatAngleScale(partialTick);
            ci.cancel();
        }
    }
}

