/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.animals.BeeVariant;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeeRenderer.class})
public class BeeRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Bee;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Bee entity, CallbackInfoReturnable<ResourceLocation> cir) {
        BeeVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
            BeeVariant beeVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof BeeVariant)) continue;
            variant = beeVariant = (BeeVariant)object;
            break;
        }
        if (variant != null) {
            ResourceLocation texture = entity.hasNectar() ? (entity.isAngry() ? variant.angryNectarTexture : variant.nectarTexture) : (entity.isAngry() ? variant.angryTexture : variant.texture);
            cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
        }
    }
}

