/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.animals.CamelVariant;
import net.minecraft.client.renderer.entity.CamelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CamelRenderer.class})
public class CamelRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/camel/Camel;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Camel entity, CallbackInfoReturnable<ResourceLocation> cir) {
        CamelVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
            CamelVariant camelVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof CamelVariant)) continue;
            variant = camelVariant = (CamelVariant)object;
            break;
        }
        if (variant != null) {
            ResourceLocation texture = entity.isBaby() ? variant.babyTexture : variant.texture;
            cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
        }
    }
}

